/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.action;

import org.elasticsearch.ElasticsearchSecurityException;
import org.elasticsearch.ElasticsearchStatusException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.TransportAction;
import org.elasticsearch.common.settings.SecureString;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.transport.TransportRequest;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.security.action.Grant;
import org.elasticsearch.xpack.core.security.action.GrantRequest;
import org.elasticsearch.xpack.core.security.action.user.AuthenticateRequest;
import org.elasticsearch.xpack.core.security.authc.Authentication;
import org.elasticsearch.xpack.core.security.authc.AuthenticationToken;
import org.elasticsearch.xpack.core.security.authc.support.BearerToken;
import org.elasticsearch.xpack.core.security.authc.support.UsernamePasswordToken;
import org.elasticsearch.xpack.security.authc.AuthenticationService;
import org.elasticsearch.xpack.security.authc.jwt.JwtAuthenticationToken;
import org.elasticsearch.xpack.security.authz.AuthorizationService;

public abstract class TransportGrantAction<Request extends GrantRequest, Response extends ActionResponse>
extends TransportAction<Request, Response> {
    protected final AuthenticationService authenticationService;
    protected final AuthorizationService authorizationService;
    protected final ThreadContext threadContext;

    public TransportGrantAction(String actionName, TransportService transportService, ActionFilters actionFilters, AuthenticationService authenticationService, AuthorizationService authorizationService, ThreadContext threadContext) {
        super(actionName, actionFilters, transportService.getTaskManager());
        this.authenticationService = authenticationService;
        this.authorizationService = authorizationService;
        this.threadContext = threadContext;
    }

    public final void doExecute(Task task, Request request, ActionListener<Response> listener) {
        try (ThreadContext.StoredContext ignore = this.threadContext.stashContext();){
            AuthenticationToken authenticationToken = TransportGrantAction.getAuthenticationToken(request.getGrant());
            assert (authenticationToken != null) : "authentication token must not be null";
            String runAsUsername = request.getGrant().getRunAsUsername();
            ActionListener authenticationListener = ActionListener.wrap(authentication -> {
                if (authentication.isRunAs()) {
                    String effectiveUsername = authentication.getEffectiveSubject().getUser().principal();
                    if (runAsUsername != null && !runAsUsername.equals(effectiveUsername)) {
                        listener.onFailure((Exception)new ElasticsearchStatusException("the provided grant credentials do not support run-as", RestStatus.BAD_REQUEST, new Object[0]));
                    } else {
                        assert (runAsUsername != null || "access_token".equals(request.getGrant().getType()));
                        this.authorizationService.authorize((Authentication)authentication, "cluster:admin/xpack/security/user/authenticate", (TransportRequest)AuthenticateRequest.INSTANCE, (ActionListener<Void>)ActionListener.wrap(ignore2 -> this.doExecuteWithGrantAuthentication(task, request, (Authentication)authentication, listener), arg_0 -> ((ActionListener)listener).onFailure(arg_0)));
                    }
                } else if (runAsUsername != null) {
                    listener.onFailure((Exception)new ElasticsearchStatusException("the provided grant credentials do not support run-as", RestStatus.BAD_REQUEST, new Object[0]));
                } else {
                    this.doExecuteWithGrantAuthentication(task, request, (Authentication)authentication, listener);
                }
            }, arg_0 -> listener.onFailure(arg_0));
            if (runAsUsername != null) {
                this.threadContext.putHeader("es-security-runas-user", runAsUsername);
            }
            this.authenticationService.authenticate(this.actionName, (TransportRequest)request, authenticationToken, (ActionListener<Authentication>)ActionListener.runBefore((ActionListener)authenticationListener, () -> ((AuthenticationToken)authenticationToken).clearCredentials()));
        }
        catch (Exception e) {
            listener.onFailure(e);
        }
    }

    protected abstract void doExecuteWithGrantAuthentication(Task var1, Request var2, Authentication var3, ActionListener<Response> var4);

    public static AuthenticationToken getAuthenticationToken(Grant grant) {
        assert (grant.validate(null) == null) : "grant is invalid";
        return switch (grant.getType()) {
            case "password" -> new UsernamePasswordToken(grant.getUsername(), grant.getPassword());
            case "access_token" -> {
                SecureString clientAuthentication = grant.getClientAuthentication() != null ? grant.getClientAuthentication().value() : null;
                JwtAuthenticationToken token = JwtAuthenticationToken.tryParseJwt(grant.getAccessToken(), clientAuthentication);
                if (token != null) {
                    yield token;
                }
                if (clientAuthentication != null) {
                    clientAuthentication.close();
                    throw new ElasticsearchSecurityException("[client_authentication] not supported with the supplied access_token type", RestStatus.BAD_REQUEST, new Object[0]);
                }
                yield new BearerToken(grant.getAccessToken());
            }
            default -> throw new ElasticsearchSecurityException("the grant type [{}] is not supported", new Object[]{grant.getType()});
        };
    }
}

