/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.security.transport.netty4;

import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelOutboundHandlerAdapter;
import io.netty.channel.ChannelPromise;
import io.netty.handler.ssl.SslHandler;
import io.netty.util.concurrent.Future;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Collections;
import java.util.Map;
import javax.net.ssl.SNIHostName;
import javax.net.ssl.SNIServerName;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLParameters;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.network.NetworkService;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.ssl.SslConfiguration;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.util.PageCacheRecycler;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.indices.breaker.CircuitBreakerService;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.ConnectTransportException;
import org.elasticsearch.transport.ConnectionProfile;
import org.elasticsearch.transport.Header;
import org.elasticsearch.transport.HeaderValidationException;
import org.elasticsearch.transport.InboundAggregator;
import org.elasticsearch.transport.InboundDecoder;
import org.elasticsearch.transport.InboundPipeline;
import org.elasticsearch.transport.RemoteClusterPortSettings;
import org.elasticsearch.transport.TcpChannel;
import org.elasticsearch.transport.Transport;
import org.elasticsearch.transport.TransportSettings;
import org.elasticsearch.transport.netty4.Netty4Transport;
import org.elasticsearch.transport.netty4.SharedGroupFactory;
import org.elasticsearch.xpack.core.XPackSettings;
import org.elasticsearch.xpack.core.security.transport.ProfileConfigurations;
import org.elasticsearch.xpack.core.security.transport.SecurityTransportExceptionHandler;
import org.elasticsearch.xpack.core.ssl.SSLService;
import org.elasticsearch.xpack.security.authc.CrossClusterAccessAuthenticationService;

public class SecurityNetty4Transport
extends Netty4Transport {
    private static final Logger logger = LogManager.getLogger(SecurityNetty4Transport.class);
    private final SecurityTransportExceptionHandler exceptionHandler;
    private final SSLService sslService;
    private final SslConfiguration defaultSslConfiguration;
    private final Map<String, SslConfiguration> profileConfigurations;
    private final boolean transportSslEnabled;
    private final boolean remoteClusterServerSslEnabled;
    private final SslConfiguration remoteClusterClientSslConfiguration;
    private final RemoteClusterClientBootstrapOptions remoteClusterClientBootstrapOptions;
    private final CrossClusterAccessAuthenticationService crossClusterAccessAuthenticationService;

    public SecurityNetty4Transport(Settings settings, TransportVersion version, ThreadPool threadPool, NetworkService networkService, PageCacheRecycler pageCacheRecycler, NamedWriteableRegistry namedWriteableRegistry, CircuitBreakerService circuitBreakerService, SSLService sslService, SharedGroupFactory sharedGroupFactory, CrossClusterAccessAuthenticationService crossClusterAccessAuthenticationService) {
        super(settings, version, threadPool, networkService, pageCacheRecycler, namedWriteableRegistry, circuitBreakerService, sharedGroupFactory);
        this.crossClusterAccessAuthenticationService = crossClusterAccessAuthenticationService;
        this.exceptionHandler = new SecurityTransportExceptionHandler(logger, this.lifecycle, (c, e) -> super.onException(c, e));
        this.sslService = sslService;
        this.transportSslEnabled = (Boolean)XPackSettings.TRANSPORT_SSL_ENABLED.get(settings);
        this.remoteClusterServerSslEnabled = (Boolean)XPackSettings.REMOTE_CLUSTER_SERVER_SSL_ENABLED.get(settings);
        this.profileConfigurations = Collections.unmodifiableMap(ProfileConfigurations.get(settings, sslService, true));
        this.defaultSslConfiguration = this.profileConfigurations.get("default");
        assert (!this.transportSslEnabled || this.defaultSslConfiguration != null);
        if (((Boolean)XPackSettings.REMOTE_CLUSTER_CLIENT_SSL_ENABLED.get(settings)).booleanValue()) {
            this.remoteClusterClientSslConfiguration = sslService.getSSLConfiguration(XPackSettings.REMOTE_CLUSTER_CLIENT_SSL_PREFIX);
            assert (this.remoteClusterClientSslConfiguration != null);
        } else {
            this.remoteClusterClientSslConfiguration = null;
        }
        this.remoteClusterClientBootstrapOptions = RemoteClusterClientBootstrapOptions.fromSettings(settings);
    }

    protected void doStart() {
        super.doStart();
    }

    public final ChannelHandler getServerChannelInitializer(String name) {
        if (this.remoteClusterPortEnabled && "_remote_cluster".equals(name)) {
            if (this.remoteClusterServerSslEnabled) {
                SslConfiguration remoteClusterSslConfiguration = this.profileConfigurations.get(name);
                if (remoteClusterSslConfiguration == null) {
                    throw new IllegalStateException("remote cluster SSL is enabled but no configuration is found");
                }
                return this.getSslChannelInitializer(name, remoteClusterSslConfiguration);
            }
            return this.getNoSslChannelInitializer(name);
        }
        if (this.transportSslEnabled) {
            SslConfiguration configuration = this.profileConfigurations.get(name);
            if (configuration == null) {
                throw new IllegalStateException("unknown profile: " + name);
            }
            return this.getSslChannelInitializer(name, configuration);
        }
        return this.getNoSslChannelInitializer(name);
    }

    protected ChannelHandler getNoSslChannelInitializer(String name) {
        return super.getServerChannelInitializer(name);
    }

    protected ChannelHandler getClientChannelInitializer(DiscoveryNode node, ConnectionProfile connectionProfile) {
        return new SecurityClientChannelInitializer(node, connectionProfile);
    }

    protected InboundPipeline getInboundPipeline(final Channel channel, boolean isRemoteClusterServerChannel) {
        if (!isRemoteClusterServerChannel) {
            return super.getInboundPipeline(channel, false);
        }
        return new InboundPipeline(this.getStatsTracker(), () -> ((ThreadPool)this.threadPool).relativeTimeInMillis(), new InboundDecoder(this.recycler, (ByteSizeValue)RemoteClusterPortSettings.MAX_REQUEST_HEADER_SIZE.get(this.settings), InboundDecoder.ChannelType.SERVER), new InboundAggregator(this.getInflightBreaker(), arg_0 -> ((Transport.RequestHandlers)this.getRequestHandlers()).getHandler(arg_0), this.ignoreDeserializationErrors()), (arg_0, arg_1) -> ((SecurityNetty4Transport)this).inboundMessage(arg_0, arg_1)){

            protected void headerReceived(Header header) {
                if (!header.isHandshake()) {
                    assert (header.isRequest());
                    channel.config().setAutoRead(false);
                    try (ThreadContext.StoredContext ignore = SecurityNetty4Transport.this.threadPool.getThreadContext().newStoredContext();){
                        SecurityNetty4Transport.this.crossClusterAccessAuthenticationService.tryAuthenticate(header.getRequestHeaders(), (ActionListener<Void>)ActionListener.runAfter((ActionListener)ActionListener.wrap(aVoid -> logger.debug("Transport CCS authentication SUCCESS for [{}] on channel [{}]", (Object)header, (Object)channel), e -> {
                            logger.debug("Transport CCS authentication FAIL for [{}] with [{}], closing channel [{}]", (Object)header, (Object)e.getMessage(), (Object)channel);
                            channel.eventLoop().submit(() -> channel.pipeline().fireExceptionCaught((Throwable)new HeaderValidationException(header, e)));
                        }), () -> channel.config().setAutoRead(true)));
                    }
                }
                super.headerReceived(header);
            }
        };
    }

    protected Bootstrap getClientBootstrap(ConnectionProfile connectionProfile) {
        Bootstrap bootstrap = super.getClientBootstrap(connectionProfile);
        if (!"_remote_cluster".equals(connectionProfile.getTransportProfile()) || this.remoteClusterClientBootstrapOptions.isEmpty()) {
            return bootstrap;
        }
        logger.trace("reconfiguring client bootstrap for remote cluster client connection");
        this.remoteClusterClientBootstrapOptions.configure(bootstrap);
        return bootstrap;
    }

    public void onException(TcpChannel channel, Exception e) {
        this.exceptionHandler.accept(channel, e);
    }

    protected Netty4Transport.ServerChannelInitializer getSslChannelInitializer(String name, SslConfiguration configuration) {
        return new SslChannelInitializer(name, configuration);
    }

    public boolean isSecure() {
        return this.transportSslEnabled;
    }

    record RemoteClusterClientBootstrapOptions(Boolean tcpNoDelay, Boolean tcpKeepAlive, Integer tcpKeepIdle, Integer tcpKeepInterval, Integer tcpKeepCount, ByteSizeValue tcpSendBufferSize, ByteSizeValue tcpReceiveBufferSize, Boolean tcpReuseAddress) {
        boolean isEmpty() {
            return this.tcpNoDelay == null && this.tcpKeepAlive == null && this.tcpKeepIdle == null && this.tcpKeepInterval == null && this.tcpKeepCount == null && this.tcpSendBufferSize == null && this.tcpReceiveBufferSize == null && this.tcpReuseAddress == null;
        }

        void configure(Bootstrap bootstrap) {
            if (this.tcpNoDelay != null) {
                bootstrap.option(ChannelOption.TCP_NODELAY, (Object)this.tcpNoDelay);
            }
            if (this.tcpKeepAlive != null) {
                bootstrap.option(ChannelOption.SO_KEEPALIVE, (Object)this.tcpKeepAlive);
                if (this.tcpKeepAlive.booleanValue()) {
                    if (this.tcpKeepIdle != null) {
                        if (this.tcpKeepIdle >= 0) {
                            bootstrap.option(Netty4Transport.OPTION_TCP_KEEP_IDLE, (Object)this.tcpKeepIdle);
                        } else {
                            bootstrap.option(Netty4Transport.OPTION_TCP_KEEP_IDLE, null);
                        }
                    }
                    if (this.tcpKeepInterval != null) {
                        if (this.tcpKeepInterval >= 0) {
                            bootstrap.option(Netty4Transport.OPTION_TCP_KEEP_INTERVAL, (Object)this.tcpKeepInterval);
                        } else {
                            bootstrap.option(Netty4Transport.OPTION_TCP_KEEP_INTERVAL, null);
                        }
                    }
                    if (this.tcpKeepCount != null) {
                        if (this.tcpKeepCount >= 0) {
                            bootstrap.option(Netty4Transport.OPTION_TCP_KEEP_COUNT, (Object)this.tcpKeepCount);
                        } else {
                            bootstrap.option(Netty4Transport.OPTION_TCP_KEEP_COUNT, null);
                        }
                    }
                } else {
                    bootstrap.option(Netty4Transport.OPTION_TCP_KEEP_IDLE, null);
                    bootstrap.option(Netty4Transport.OPTION_TCP_KEEP_INTERVAL, null);
                    bootstrap.option(Netty4Transport.OPTION_TCP_KEEP_COUNT, null);
                }
            }
            if (this.tcpSendBufferSize != null) {
                if (this.tcpSendBufferSize.getBytes() > 0L) {
                    bootstrap.option(ChannelOption.SO_SNDBUF, (Object)Math.toIntExact(this.tcpSendBufferSize.getBytes()));
                } else {
                    bootstrap.option(ChannelOption.SO_SNDBUF, null);
                }
            }
            if (this.tcpReceiveBufferSize != null) {
                if (this.tcpReceiveBufferSize.getBytes() > 0L) {
                    bootstrap.option(ChannelOption.SO_RCVBUF, (Object)Math.toIntExact(this.tcpReceiveBufferSize.getBytes()));
                } else {
                    bootstrap.option(ChannelOption.SO_RCVBUF, null);
                }
            }
            if (this.tcpReuseAddress != null) {
                bootstrap.option(ChannelOption.SO_REUSEADDR, (Object)this.tcpReuseAddress);
            }
        }

        static RemoteClusterClientBootstrapOptions fromSettings(Settings settings) {
            Boolean tcpReuseAddress;
            ByteSizeValue tcpReceiveBufferSize;
            Boolean tcpNoDelay = (Boolean)RemoteClusterPortSettings.TCP_NO_DELAY.get(settings);
            if (tcpNoDelay == TransportSettings.TCP_NO_DELAY.get(settings)) {
                tcpNoDelay = null;
            }
            Boolean tcpKeepAlive = (Boolean)RemoteClusterPortSettings.TCP_KEEP_ALIVE.get(settings);
            Integer tcpKeepIdle = (Integer)RemoteClusterPortSettings.TCP_KEEP_IDLE.get(settings);
            Integer tcpKeepInterval = (Integer)RemoteClusterPortSettings.TCP_KEEP_INTERVAL.get(settings);
            Integer tcpKeepCount = (Integer)RemoteClusterPortSettings.TCP_KEEP_COUNT.get(settings);
            Boolean defaultTcpKeepAlive = (Boolean)TransportSettings.TCP_KEEP_ALIVE.get(settings);
            if (tcpKeepAlive.booleanValue()) {
                if (defaultTcpKeepAlive.booleanValue()) {
                    if (tcpKeepIdle.equals(TransportSettings.TCP_KEEP_IDLE.get(settings))) {
                        tcpKeepIdle = null;
                    }
                    if (tcpKeepInterval.equals(TransportSettings.TCP_KEEP_INTERVAL.get(settings))) {
                        tcpKeepInterval = null;
                    }
                    if (tcpKeepCount.equals(TransportSettings.TCP_KEEP_COUNT.get(settings))) {
                        tcpKeepCount = null;
                    }
                    if (tcpKeepIdle == null && tcpKeepInterval == null && tcpKeepCount == null) {
                        tcpKeepAlive = null;
                    }
                }
            } else {
                if (!defaultTcpKeepAlive.booleanValue()) {
                    tcpKeepAlive = null;
                }
                tcpKeepIdle = null;
                tcpKeepInterval = null;
                tcpKeepCount = null;
            }
            assert (tcpKeepAlive == null && tcpKeepIdle == null && tcpKeepInterval == null && tcpKeepCount == null || !tcpKeepAlive.booleanValue() && tcpKeepIdle == null && tcpKeepInterval == null && tcpKeepCount == null || tcpKeepAlive.booleanValue() && (tcpKeepIdle != null || tcpKeepInterval != null || tcpKeepCount != null)) : "keepAlive == true must be accompanied with either keepIdle, keepInterval or keepCount change";
            ByteSizeValue tcpSendBufferSize = (ByteSizeValue)RemoteClusterPortSettings.TCP_SEND_BUFFER_SIZE.get(settings);
            if (tcpSendBufferSize.equals(TransportSettings.TCP_SEND_BUFFER_SIZE.get(settings))) {
                tcpSendBufferSize = null;
            }
            if ((tcpReceiveBufferSize = (ByteSizeValue)RemoteClusterPortSettings.TCP_RECEIVE_BUFFER_SIZE.get(settings)).equals(TransportSettings.TCP_RECEIVE_BUFFER_SIZE.get(settings))) {
                tcpReceiveBufferSize = null;
            }
            if ((tcpReuseAddress = (Boolean)RemoteClusterPortSettings.TCP_REUSE_ADDRESS.get(settings)) == TransportSettings.TCP_REUSE_ADDRESS.get(settings)) {
                tcpReuseAddress = null;
            }
            return new RemoteClusterClientBootstrapOptions(tcpNoDelay, tcpKeepAlive, tcpKeepIdle, tcpKeepInterval, tcpKeepCount, tcpSendBufferSize, tcpReceiveBufferSize, tcpReuseAddress);
        }
    }

    private class SecurityClientChannelInitializer
    extends Netty4Transport.ClientChannelInitializer {
        private final boolean hostnameVerificationEnabled;
        private final SNIHostName serverName;
        private final SslConfiguration channelSslConfiguration;

        SecurityClientChannelInitializer(DiscoveryNode node, ConnectionProfile connectionProfile) {
            super((Netty4Transport)SecurityNetty4Transport.this);
            String transportProfile = connectionProfile.getTransportProfile();
            logger.trace("initiating security client channel with transport profile [{}]", (Object)transportProfile);
            if ("_remote_cluster".equals(transportProfile)) {
                this.channelSslConfiguration = SecurityNetty4Transport.this.remoteClusterClientSslConfiguration;
            } else {
                assert ("default".equals(transportProfile));
                this.channelSslConfiguration = SecurityNetty4Transport.this.defaultSslConfiguration;
            }
            this.hostnameVerificationEnabled = this.channelSslConfiguration != null ? this.channelSslConfiguration.verificationMode().isHostnameVerificationEnabled() : false;
            String configuredServerName = (String)node.getAttributes().get("server_name");
            if (configuredServerName != null) {
                try {
                    this.serverName = new SNIHostName(configuredServerName);
                }
                catch (IllegalArgumentException e) {
                    throw new ConnectTransportException(node, "invalid DiscoveryNode server_name [" + configuredServerName + "]", (Throwable)e);
                }
            } else {
                this.serverName = null;
            }
        }

        protected void initChannel(Channel ch) throws Exception {
            super.initChannel(ch);
            if (this.channelSslConfiguration != null) {
                ch.pipeline().addFirst(new ChannelHandler[]{new ClientSslHandlerInitializer(this.channelSslConfiguration, SecurityNetty4Transport.this.sslService, this.hostnameVerificationEnabled, this.serverName)});
            }
        }
    }

    public class SslChannelInitializer
    extends Netty4Transport.ServerChannelInitializer {
        private final SslConfiguration configuration;

        public SslChannelInitializer(String name, SslConfiguration configuration) {
            super((Netty4Transport)SecurityNetty4Transport.this, name);
            this.configuration = configuration;
        }

        protected void initChannel(Channel ch) throws Exception {
            SSLEngine serverEngine = SecurityNetty4Transport.this.sslService.createSSLEngine(this.configuration, null, -1);
            serverEngine.setUseClientMode(false);
            SslHandler sslHandler = new SslHandler(serverEngine);
            ch.pipeline().addFirst("sslhandler", (ChannelHandler)sslHandler);
            super.initChannel(ch);
            assert (ch.pipeline().first() == sslHandler) : "SSL handler must be first handler in pipeline";
        }
    }

    private static class ClientSslHandlerInitializer
    extends ChannelOutboundHandlerAdapter {
        private final boolean hostnameVerificationEnabled;
        private final SslConfiguration sslConfiguration;
        private final SSLService sslService;
        private final SNIServerName serverName;

        private ClientSslHandlerInitializer(SslConfiguration sslConfiguration, SSLService sslService, boolean hostnameVerificationEnabled, SNIServerName serverName) {
            this.sslConfiguration = sslConfiguration;
            this.hostnameVerificationEnabled = hostnameVerificationEnabled;
            this.sslService = sslService;
            this.serverName = serverName;
        }

        public void connect(ChannelHandlerContext ctx, SocketAddress remoteAddress, SocketAddress localAddress, ChannelPromise promise) throws Exception {
            SSLEngine sslEngine;
            if (this.hostnameVerificationEnabled) {
                InetSocketAddress inetSocketAddress = (InetSocketAddress)remoteAddress;
                sslEngine = this.sslService.createSSLEngine(this.sslConfiguration, inetSocketAddress.getHostString(), inetSocketAddress.getPort());
            } else {
                sslEngine = this.sslService.createSSLEngine(this.sslConfiguration, null, -1);
            }
            sslEngine.setUseClientMode(true);
            if (this.serverName != null) {
                SSLParameters sslParameters = sslEngine.getSSLParameters();
                sslParameters.setServerNames(Collections.singletonList(this.serverName));
                sslEngine.setSSLParameters(sslParameters);
            }
            ChannelPromise connectPromise = ctx.newPromise();
            SslHandler sslHandler = new SslHandler(sslEngine);
            ctx.pipeline().replace((ChannelHandler)this, "ssl", (ChannelHandler)sslHandler);
            Future handshakePromise = sslHandler.handshakeFuture();
            connectPromise.addListener(result -> {
                if (!result.isSuccess()) {
                    promise.tryFailure(result.cause());
                } else {
                    handshakePromise.addListener(handshakeResult -> {
                        if (handshakeResult.isSuccess()) {
                            promise.setSuccess();
                        } else {
                            promise.tryFailure(handshakeResult.cause());
                        }
                    });
                }
            });
            super.connect(ctx, remoteAddress, localAddress, connectPromise);
        }
    }
}

