/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.application.rules.action;

import java.util.concurrent.Executor;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.application.rules.QueryRule;
import org.elasticsearch.xpack.application.rules.QueryRulesIndexService;
import org.elasticsearch.xpack.application.rules.action.PutQueryRuleAction;

public class TransportPutQueryRuleAction
extends HandledTransportAction<PutQueryRuleAction.Request, PutQueryRuleAction.Response> {
    protected final QueryRulesIndexService systemIndexService;

    @Inject
    public TransportPutQueryRuleAction(TransportService transportService, ClusterService clusterService, ActionFilters actionFilters, Client client) {
        super("cluster:admin/xpack/query_rules/rule/put", transportService, actionFilters, PutQueryRuleAction.Request::new, (Executor)EsExecutors.DIRECT_EXECUTOR_SERVICE);
        this.systemIndexService = new QueryRulesIndexService(client, clusterService.getClusterSettings());
    }

    protected void doExecute(Task task, PutQueryRuleAction.Request request, ActionListener<PutQueryRuleAction.Response> listener) {
        String queryRulesetId = request.queryRulesetId();
        QueryRule queryRule = request.queryRule();
        this.systemIndexService.putQueryRule(queryRulesetId, queryRule, (ActionListener<PutQueryRuleAction.Response>)ActionListener.wrap(arg_0 -> listener.onResponse(arg_0), arg_0 -> listener.onFailure(arg_0)));
    }
}

