/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.application.rules;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import org.apache.lucene.search.Query;
import org.apache.lucene.util.SetOnce;
import org.elasticsearch.ResourceNotFoundException;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.get.GetResponse;
import org.elasticsearch.action.get.MultiGetItemResponse;
import org.elasticsearch.action.get.MultiGetRequest;
import org.elasticsearch.action.get.TransportMultiGetAction;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.common.ParsingException;
import org.elasticsearch.common.VersionId;
import org.elasticsearch.common.io.stream.NamedWriteable;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.logging.HeaderWarning;
import org.elasticsearch.index.query.AbstractQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryRewriteContext;
import org.elasticsearch.index.query.SearchExecutionContext;
import org.elasticsearch.license.LicenseUtils;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xcontent.XContentType;
import org.elasticsearch.xpack.application.rules.AppliedQueryRules;
import org.elasticsearch.xpack.application.rules.QueryRule;
import org.elasticsearch.xpack.application.rules.QueryRulesConfig;
import org.elasticsearch.xpack.application.rules.QueryRuleset;
import org.elasticsearch.xpack.core.ClientHelper;
import org.elasticsearch.xpack.searchbusinessrules.PinnedQueryBuilder;

public class RuleQueryBuilder
extends AbstractQueryBuilder<RuleQueryBuilder> {
    public static final ParseField NAME = new ParseField("rule", new String[]{"rule_query"});
    private static final ParseField RULESET_ID_FIELD = new ParseField("ruleset_id", new String[0]);
    private static final ParseField RULESET_IDS_FIELD = new ParseField("ruleset_ids", new String[0]);
    static final ParseField MATCH_CRITERIA_FIELD = new ParseField("match_criteria", new String[0]);
    private static final ParseField ORGANIC_QUERY_FIELD = new ParseField("organic", new String[0]);
    public static final int MAX_NUM_RULESETS = 10;
    private final List<String> rulesetIds;
    private final Map<String, Object> matchCriteria;
    private final QueryBuilder organicQuery;
    private final Supplier<List<String>> pinnedIdsSupplier;
    private final Supplier<List<PinnedQueryBuilder.Item>> pinnedDocsSupplier;
    private static final ConstructingObjectParser<RuleQueryBuilder, Void> PARSER = new ConstructingObjectParser(NAME.getPreferredName(), a -> {
        List<String> rulesetIds;
        QueryBuilder organicQuery = (QueryBuilder)a[0];
        Map matchCriteria = (Map)a[1];
        String rulesetId = (String)a[2];
        if (rulesetId == null ^ !((rulesetIds = (List<String>)a[3]) == null)) {
            throw new IllegalArgumentException("ruleset information not provided correctly");
        }
        if (rulesetIds == null) {
            HeaderWarning.addWarning((String)"Using deprecated field [ruleset_id] in query rules, please use [ruleset_ids] instead", (Object[])new Object[0]);
            rulesetIds = List.of(rulesetId);
        }
        return new RuleQueryBuilder(organicQuery, matchCriteria, rulesetIds);
    });

    public TransportVersion getMinimalSupportedVersion() {
        return TransportVersions.V_8_10_X;
    }

    public RuleQueryBuilder(QueryBuilder organicQuery, Map<String, Object> matchCriteria, List<String> rulesetIds) {
        this(organicQuery, matchCriteria, rulesetIds, null, null);
    }

    public RuleQueryBuilder(StreamInput in) throws IOException {
        super(in);
        this.organicQuery = (QueryBuilder)in.readNamedWriteable(QueryBuilder.class);
        this.matchCriteria = in.readGenericMap();
        if (in.getTransportVersion().onOrAfter((VersionId)TransportVersions.RULE_QUERY_RENAME)) {
            this.rulesetIds = in.readStringCollectionAsList();
        } else {
            this.rulesetIds = List.of(in.readString());
            in.readOptionalStringCollectionAsList();
            in.readOptionalCollectionAsList(PinnedQueryBuilder.Item::new);
        }
        this.pinnedIdsSupplier = null;
        this.pinnedDocsSupplier = null;
    }

    private RuleQueryBuilder(QueryBuilder organicQuery, Map<String, Object> matchCriteria, List<String> rulesetIds, Supplier<List<String>> pinnedIdsSupplier, Supplier<List<PinnedQueryBuilder.Item>> pinnedDocsSupplier) {
        if (organicQuery == null) {
            throw new IllegalArgumentException("organicQuery must not be null");
        }
        if (matchCriteria == null || matchCriteria.isEmpty()) {
            throw new IllegalArgumentException("matchCriteria must not be null or empty");
        }
        if (rulesetIds == null || rulesetIds.isEmpty()) {
            throw new IllegalArgumentException("rulesetIds must not be null or empty");
        }
        if (rulesetIds.size() > 10) {
            throw new IllegalArgumentException("rulesetIds must not contain more than 10 rulesets");
        }
        if (rulesetIds.stream().anyMatch(ruleset -> ruleset == null || ruleset.isEmpty())) {
            throw new IllegalArgumentException("rulesetIds must not contain null or empty values");
        }
        this.organicQuery = organicQuery;
        this.matchCriteria = matchCriteria;
        this.rulesetIds = rulesetIds;
        this.pinnedIdsSupplier = pinnedIdsSupplier;
        this.pinnedDocsSupplier = pinnedDocsSupplier;
    }

    protected void doWriteTo(StreamOutput out) throws IOException {
        if (this.pinnedIdsSupplier != null) {
            throw new IllegalStateException("pinnedIdsSupplier must be null, can't serialize suppliers, missing a rewriteAndFetch?");
        }
        if (this.pinnedDocsSupplier != null) {
            throw new IllegalStateException("pinnedDocsSupplier must be null, can't serialize suppliers, missing a rewriteAndFetch?");
        }
        out.writeNamedWriteable((NamedWriteable)this.organicQuery);
        out.writeGenericMap(this.matchCriteria);
        if (out.getTransportVersion().onOrAfter((VersionId)TransportVersions.RULE_QUERY_RENAME)) {
            out.writeStringCollection(this.rulesetIds);
        } else {
            out.writeString(this.rulesetIds.get(0));
            out.writeOptionalStringCollection(null);
            out.writeOptionalCollection(null);
        }
    }

    public List<String> rulesetIds() {
        return this.rulesetIds;
    }

    public Map<String, Object> matchCriteria() {
        return this.matchCriteria;
    }

    public QueryBuilder organicQuery() {
        return this.organicQuery;
    }

    protected void doXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(NAME.getPreferredName());
        builder.field(ORGANIC_QUERY_FIELD.getPreferredName(), (ToXContent)this.organicQuery);
        builder.startObject(MATCH_CRITERIA_FIELD.getPreferredName());
        builder.mapContents(this.matchCriteria);
        builder.endObject();
        builder.array(RULESET_IDS_FIELD.getPreferredName(), this.rulesetIds.toArray());
        this.boostAndQueryNameToXContent(builder);
        builder.endObject();
    }

    protected Query doToQuery(SearchExecutionContext context) throws IOException {
        List<PinnedQueryBuilder.Item> pinnedDocs;
        List<String> pinnedIds = this.pinnedIdsSupplier != null ? this.pinnedIdsSupplier.get() : null;
        List<PinnedQueryBuilder.Item> list = pinnedDocs = this.pinnedDocsSupplier != null ? this.pinnedDocsSupplier.get() : null;
        if (pinnedIds != null && !pinnedIds.isEmpty() && pinnedDocs != null && !pinnedDocs.isEmpty()) {
            throw new IllegalArgumentException("applied rules contain both pinned ids and pinned docs, only one of ids or docs is allowed");
        }
        if (pinnedIds != null && !pinnedIds.isEmpty()) {
            PinnedQueryBuilder pinnedQueryBuilder = new PinnedQueryBuilder(this.organicQuery, pinnedIds.toArray(new String[0]));
            return pinnedQueryBuilder.toQuery(context);
        }
        if (pinnedDocs != null && !pinnedDocs.isEmpty()) {
            PinnedQueryBuilder pinnedQueryBuilder = new PinnedQueryBuilder(this.organicQuery, pinnedDocs.toArray(new PinnedQueryBuilder.Item[0]));
            return pinnedQueryBuilder.toQuery(context);
        }
        return this.organicQuery.toQuery(context);
    }

    protected QueryBuilder doRewrite(QueryRewriteContext queryRewriteContext) {
        if (this.pinnedIdsSupplier != null && this.pinnedDocsSupplier != null) {
            List<String> identifiedPinnedIds = this.pinnedIdsSupplier.get();
            List<PinnedQueryBuilder.Item> identifiedPinnedDocs = this.pinnedDocsSupplier.get();
            if (identifiedPinnedIds == null || identifiedPinnedDocs == null) {
                return this;
            }
            if (identifiedPinnedIds.isEmpty() && identifiedPinnedDocs.isEmpty()) {
                return this.organicQuery;
            }
            if (!identifiedPinnedIds.isEmpty() && !identifiedPinnedDocs.isEmpty()) {
                throw new IllegalArgumentException("applied rules contain both pinned ids and pinned docs, only one of ids or docs is allowed");
            }
            if (!identifiedPinnedIds.isEmpty()) {
                return new PinnedQueryBuilder(this.organicQuery, this.truncateList(identifiedPinnedIds).toArray(new String[0]));
            }
            return new PinnedQueryBuilder(this.organicQuery, this.truncateList(identifiedPinnedDocs).toArray(new PinnedQueryBuilder.Item[0]));
        }
        SetOnce pinnedIdsSetOnce = new SetOnce();
        SetOnce pinnedDocsSetOnce = new SetOnce();
        AppliedQueryRules appliedRules = new AppliedQueryRules();
        MultiGetRequest multiGetRequest = new MultiGetRequest();
        for (String rulesetId : this.rulesetIds) {
            multiGetRequest.add(".query-rules", rulesetId);
        }
        queryRewriteContext.registerAsyncAction((client, listener) -> ClientHelper.executeAsyncWithOrigin((Client)client, (String)"enterprise_search", (ActionType)TransportMultiGetAction.TYPE, (ActionRequest)multiGetRequest, (ActionListener)ActionListener.wrap(multiGetResponse -> {
            if (multiGetResponse.getResponses() == null || multiGetResponse.getResponses().length == 0) {
                listener.onFailure((Exception)((Object)new ResourceNotFoundException("query rulesets " + String.join((CharSequence)",", this.rulesetIds) + " not found", new Object[0])));
                return;
            }
            for (MultiGetItemResponse item : multiGetResponse) {
                String rulesetId = item.getId();
                GetResponse getResponse = item.getResponse();
                if (!getResponse.isExists()) {
                    listener.onFailure((Exception)((Object)new ResourceNotFoundException("query ruleset " + rulesetId + " not found", new Object[0])));
                    return;
                }
                QueryRuleset queryRuleset = QueryRuleset.fromXContentBytes(rulesetId, getResponse.getSourceAsBytesRef(), XContentType.JSON);
                for (QueryRule rule : queryRuleset.rules()) {
                    rule.applyRule(appliedRules, this.matchCriteria);
                }
            }
            pinnedIdsSetOnce.set(appliedRules.pinnedIds().stream().distinct().toList());
            pinnedDocsSetOnce.set(appliedRules.pinnedDocs().stream().distinct().toList());
            listener.onResponse(null);
        }, arg_0 -> ((ActionListener)listener).onFailure(arg_0))));
        return ((RuleQueryBuilder)new RuleQueryBuilder(this.organicQuery, this.matchCriteria, this.rulesetIds, () -> ((SetOnce)pinnedIdsSetOnce).get(), () -> ((SetOnce)pinnedDocsSetOnce).get()).boost(this.boost)).queryName(this.queryName);
    }

    private List<?> truncateList(List<?> input) {
        if (input.size() > 100) {
            HeaderWarning.addWarning((String)"Truncating query rule pinned hits to 100 documents", (Object[])new Object[0]);
            return input.subList(0, 100);
        }
        return input;
    }

    protected boolean doEquals(RuleQueryBuilder other) {
        if (this == other) {
            return true;
        }
        if (other == null || ((Object)((Object)this)).getClass() != ((Object)((Object)other)).getClass()) {
            return false;
        }
        return Objects.equals(this.rulesetIds, other.rulesetIds) && Objects.equals(this.matchCriteria, other.matchCriteria) && Objects.equals(this.organicQuery, other.organicQuery) && Objects.equals(this.pinnedIdsSupplier, other.pinnedIdsSupplier) && Objects.equals(this.pinnedDocsSupplier, other.pinnedDocsSupplier);
    }

    protected int doHashCode() {
        return Objects.hash(this.rulesetIds, this.matchCriteria, this.organicQuery, this.pinnedIdsSupplier, this.pinnedDocsSupplier);
    }

    public static RuleQueryBuilder fromXContent(XContentParser parser, XPackLicenseState licenseState) {
        if (!QueryRulesConfig.QUERY_RULES_LICENSE_FEATURE.check(licenseState)) {
            throw LicenseUtils.newComplianceException((String)NAME.getPreferredName());
        }
        try {
            return (RuleQueryBuilder)((Object)PARSER.apply(parser, null));
        }
        catch (IllegalArgumentException e) {
            throw new ParsingException(parser.getTokenLocation(), e.getMessage(), (Throwable)e, new Object[0]);
        }
    }

    public String getWriteableName() {
        return NAME.getPreferredName();
    }

    static {
        PARSER.declareObject(ConstructingObjectParser.constructorArg(), (p, c) -> RuleQueryBuilder.parseInnerQueryBuilder((XContentParser)p), ORGANIC_QUERY_FIELD);
        PARSER.declareObject(ConstructingObjectParser.constructorArg(), (p, c) -> p.map(), MATCH_CRITERIA_FIELD);
        PARSER.declareString(ConstructingObjectParser.optionalConstructorArg(), RULESET_ID_FIELD);
        PARSER.declareStringArray(ConstructingObjectParser.optionalConstructorArg(), RULESET_IDS_FIELD);
        RuleQueryBuilder.declareStandardFields(PARSER);
    }
}

