/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.application.connector.syncjob.action;

import java.util.List;
import java.util.concurrent.Executor;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.application.connector.ConnectorSyncStatus;
import org.elasticsearch.xpack.application.connector.syncjob.ConnectorSyncJobIndexService;
import org.elasticsearch.xpack.application.connector.syncjob.ConnectorSyncJobType;
import org.elasticsearch.xpack.application.connector.syncjob.action.ListConnectorSyncJobsAction;
import org.elasticsearch.xpack.core.action.util.PageParams;

public class TransportListConnectorSyncJobsAction
extends HandledTransportAction<ListConnectorSyncJobsAction.Request, ListConnectorSyncJobsAction.Response> {
    protected final ConnectorSyncJobIndexService connectorSyncJobIndexService;

    @Inject
    public TransportListConnectorSyncJobsAction(TransportService transportService, ActionFilters actionFilters, Client client) {
        super("indices:data/read/xpack/connector/sync_job/list", transportService, actionFilters, ListConnectorSyncJobsAction.Request::new, (Executor)EsExecutors.DIRECT_EXECUTOR_SERVICE);
        this.connectorSyncJobIndexService = new ConnectorSyncJobIndexService(client);
    }

    protected void doExecute(Task task, ListConnectorSyncJobsAction.Request request, ActionListener<ListConnectorSyncJobsAction.Response> listener) {
        PageParams pageParams = request.getPageParams();
        String connectorId = request.getConnectorId();
        ConnectorSyncStatus syncStatus = request.getConnectorSyncStatus();
        List<ConnectorSyncJobType> jobTypeList = request.getConnectorSyncJobTypeList();
        this.connectorSyncJobIndexService.listConnectorSyncJobs(pageParams.getFrom(), pageParams.getSize(), connectorId, syncStatus, jobTypeList, (ActionListener<ConnectorSyncJobIndexService.ConnectorSyncJobsResult>)listener.map(r -> new ListConnectorSyncJobsAction.Response(r.connectorSyncJobs(), r.totalResults())));
    }
}

