/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.application.analytics.ingest;

import java.io.IOException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.ElasticsearchStatusException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.bulk.BulkProcessor2;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.client.internal.OriginSettingClient;
import org.elasticsearch.common.component.AbstractLifecycleComponent;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.util.concurrent.EsRejectedExecutionException;
import org.elasticsearch.logging.LogManager;
import org.elasticsearch.logging.Logger;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.json.JsonXContent;
import org.elasticsearch.xpack.application.analytics.AnalyticsCollection;
import org.elasticsearch.xpack.application.analytics.AnalyticsCollectionResolver;
import org.elasticsearch.xpack.application.analytics.action.PostAnalyticsEventAction;
import org.elasticsearch.xpack.application.analytics.event.AnalyticsEvent;
import org.elasticsearch.xpack.application.analytics.event.AnalyticsEventFactory;
import org.elasticsearch.xpack.application.analytics.ingest.BulkProcessorFactory;

public class AnalyticsEventEmitter
extends AbstractLifecycleComponent {
    private static final Logger logger = LogManager.getLogger(AnalyticsEventEmitter.class);
    private final Client client;
    private final BulkProcessor2 bulkProcessor;
    private final AnalyticsEventFactory eventFactory;
    private final AnalyticsCollectionResolver collectionResolver;
    private final AtomicBoolean dropEvent = new AtomicBoolean(false);

    @Inject
    public AnalyticsEventEmitter(Client client, BulkProcessorFactory bulkProcessorFactory, AnalyticsCollectionResolver collectionResolver) {
        this(client, bulkProcessorFactory.create(), collectionResolver, AnalyticsEventFactory.INSTANCE);
    }

    AnalyticsEventEmitter(Client client, BulkProcessor2 bulkProcessor, AnalyticsCollectionResolver collectionResolver, AnalyticsEventFactory eventFactory) {
        this.client = new OriginSettingClient(client, "enterprise_search");
        this.bulkProcessor = bulkProcessor;
        this.eventFactory = eventFactory;
        this.collectionResolver = collectionResolver;
    }

    public void emitEvent(PostAnalyticsEventAction.Request request, ActionListener<PostAnalyticsEventAction.Response> listener) {
        block6: {
            try {
                AnalyticsEvent event = this.eventFactory.fromRequest(request);
                IndexRequest eventIndexRequest = this.createIndexRequest(event);
                this.bulkProcessor.add(eventIndexRequest);
                if (this.dropEvent.compareAndSet(true, false)) {
                    logger.warn("Bulk processor has been flushed. Accepting new events again.");
                }
                if (request.isDebug()) {
                    listener.onResponse((Object)new PostAnalyticsEventAction.DebugResponse(true, event));
                } else {
                    listener.onResponse((Object)PostAnalyticsEventAction.Response.ACCEPTED);
                }
            }
            catch (IOException e) {
                listener.onFailure((Exception)new ElasticsearchException("Unable to parse the event.", (Throwable)e, new Object[0]));
            }
            catch (EsRejectedExecutionException e) {
                listener.onFailure((Exception)new ElasticsearchStatusException("Unable to add the event: too many requests.", RestStatus.TOO_MANY_REQUESTS, new Object[0]));
                if (!this.dropEvent.compareAndSet(false, true)) break block6;
                logger.warn("Bulk processor is full. Start dropping events.");
            }
        }
    }

    private IndexRequest createIndexRequest(AnalyticsEvent event) throws IOException {
        AnalyticsCollection collection = this.collectionResolver.collection(event.eventCollectionName());
        try (XContentBuilder builder = JsonXContent.contentBuilder();){
            IndexRequest indexRequest = this.client.prepareIndex(collection.getEventDataStream()).setCreate(true).setSource(event.toXContent(builder, ToXContent.EMPTY_PARAMS)).request();
            return indexRequest;
        }
    }

    protected void doStart() {
    }

    protected void doStop() {
    }

    protected void doClose() {
        this.bulkProcessor.close();
    }
}

