/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.operator.mvdedupe;

import org.elasticsearch.common.util.LongLongHash;
import org.elasticsearch.compute.aggregation.GroupingAggregatorFunction;
import org.elasticsearch.compute.aggregation.blockhash.AbstractAddBlock;
import org.elasticsearch.compute.aggregation.blockhash.BlockHash;
import org.elasticsearch.compute.data.BlockFactory;
import org.elasticsearch.compute.data.IntBlock;
import org.elasticsearch.compute.data.LongBlock;
import org.elasticsearch.compute.operator.mvdedupe.MultivalueDedupeInt;
import org.elasticsearch.compute.operator.mvdedupe.MultivalueDedupeLong;

public class IntLongBlockAdd
extends AbstractAddBlock {
    private final LongLongHash hash;
    private final MultivalueDedupeInt block1;
    private final MultivalueDedupeLong block2;

    public IntLongBlockAdd(BlockFactory blockFactory, int emitBatchSize, GroupingAggregatorFunction.AddInput addInput, LongLongHash hash, IntBlock block1, LongBlock block2) {
        super(blockFactory, emitBatchSize, addInput);
        this.hash = hash;
        this.block1 = new MultivalueDedupeInt(block1);
        this.block2 = new MultivalueDedupeLong(block2);
    }

    public void add() {
        int positions = this.block1.block.getPositionCount();
        for (int p = 0; p < positions; ++p) {
            this.add1(p);
        }
        this.emitOrds();
    }

    private void add1(int position) {
        int first = this.block1.block.getFirstValueIndex(position);
        int count = this.block1.block.getValueCount(position);
        switch (count) {
            case 0: {
                this.ords.appendNull();
                this.addedValue(position);
                break;
            }
            case 1: {
                this.block1.w = 1;
                this.block1.work[0] = this.block1.block.getInt(first);
                this.add2(position, true);
                break;
            }
            default: {
                if (count < 300) {
                    this.block1.copyMissing(first, count);
                    this.add2(position, true);
                    break;
                }
                this.block1.copyAndSort(first, count);
                this.add2(position, false);
            }
        }
    }

    private void add2(int position, boolean work1IsUnique) {
        int first = this.block2.block.getFirstValueIndex(position);
        int count = this.block2.block.getValueCount(position);
        switch (count) {
            case 0: {
                this.ords.appendNull();
                this.addedValue(position);
                break;
            }
            case 1: {
                this.block2.w = 1;
                this.block2.work[0] = this.block2.block.getLong(first);
                this.finishAdd(position, work1IsUnique, true);
                break;
            }
            default: {
                if (count < 300) {
                    this.block2.copyMissing(first, count);
                    this.finishAdd(position, work1IsUnique, true);
                    break;
                }
                this.block2.copyAndSort(first, count);
                this.finishAdd(position, work1IsUnique, false);
            }
        }
    }

    private void finishAdd(int position, boolean work1IsUnique, boolean work2IsUnique) {
        if (this.block1.w == 1 && this.block2.w == 1) {
            this.ords.appendInt(Math.toIntExact(BlockHash.hashOrdToGroup(this.hash.add((long)this.block1.work[0], this.block2.work[0]))));
            this.addedValue(position);
            return;
        }
        this.ords.beginPositionEntry();
        if (work1IsUnique) {
            if (work2IsUnique) {
                this.finishAddUniqueUnique(position);
            } else {
                this.finishAddUniqueSorted(position);
            }
        } else if (work2IsUnique) {
            this.finishAddSortedUnique(position);
        } else {
            this.finishAddSortedSorted(position);
        }
        this.ords.endPositionEntry();
    }

    private void finishAddUniqueUnique(int position) {
        for (int i = 0; i < this.block1.w; ++i) {
            this.finishAddUnique(position, this.block1.work[i]);
        }
    }

    private void finishAddUniqueSorted(int position) {
        for (int i = 0; i < this.block1.w; ++i) {
            this.finishAddSorted(position, this.block1.work[i]);
        }
    }

    private void finishAddSortedUnique(int position) {
        int prev1 = this.block1.work[0];
        this.finishAddUnique(position, prev1);
        for (int i = 1; i < this.block1.w; ++i) {
            if (prev1 == this.block1.work[i]) continue;
            prev1 = this.block1.work[i];
            this.finishAddUnique(position, prev1);
        }
    }

    private void finishAddSortedSorted(int position) {
        int prev1 = this.block1.work[0];
        this.finishAddSorted(position, prev1);
        for (int i = 1; i < this.block1.w; ++i) {
            if (prev1 == this.block1.work[i]) continue;
            prev1 = this.block1.work[i];
            this.finishAddSorted(position, prev1);
        }
    }

    private void finishAddUnique(int position, int v1) {
        for (int i = 0; i < this.block2.w; ++i) {
            this.ords.appendInt(Math.toIntExact(BlockHash.hashOrdToGroup(this.hash.add((long)v1, this.block2.work[i]))));
            this.addedValueInMultivaluePosition(position);
        }
    }

    private void finishAddSorted(int position, int v1) {
        long prev2 = this.block2.work[0];
        this.ords.appendInt(Math.toIntExact(BlockHash.hashOrdToGroup(this.hash.add((long)v1, prev2))));
        this.addedValueInMultivaluePosition(position);
        for (int i = 1; i < this.block2.w; ++i) {
            if (prev2 == this.block2.work[i]) continue;
            prev2 = this.block2.work[i];
            this.ords.appendInt(Math.toIntExact(BlockHash.hashOrdToGroup(this.hash.add((long)v1, prev2))));
            this.addedValueInMultivaluePosition(position);
        }
    }
}

