/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.operator.exchange;

import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicInteger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.SubscribableListener;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.compute.operator.Operator;

final class ExchangeBuffer {
    private final Queue<Page> queue = new ConcurrentLinkedQueue<Page>();
    private final AtomicInteger queueSize = new AtomicInteger();
    private final int maxSize;
    private final Object notEmptyLock = new Object();
    private SubscribableListener<Void> notEmptyFuture = null;
    private final Object notFullLock = new Object();
    private SubscribableListener<Void> notFullFuture = null;
    private final SubscribableListener<Void> completionFuture = new SubscribableListener();
    private volatile boolean noMoreInputs = false;

    ExchangeBuffer(int maxSize) {
        if (maxSize < 1) {
            throw new IllegalArgumentException("max_buffer_size must be at least one; got=" + maxSize);
        }
        this.maxSize = maxSize;
    }

    void addPage(Page page) {
        this.queue.add(page);
        if (this.queueSize.incrementAndGet() == 1) {
            this.notifyNotEmpty();
        }
        if (this.noMoreInputs) {
            this.discardPages();
        }
    }

    Page pollPage() {
        Page page = this.queue.poll();
        if (page != null && this.queueSize.decrementAndGet() == this.maxSize - 1) {
            this.notifyNotFull();
        }
        if (page == null && this.noMoreInputs && this.queueSize.get() == 0) {
            this.completionFuture.onResponse(null);
        }
        return page;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyNotEmpty() {
        SubscribableListener<Void> toNotify;
        Object object = this.notEmptyLock;
        synchronized (object) {
            toNotify = this.notEmptyFuture;
            this.notEmptyFuture = null;
        }
        if (toNotify != null) {
            toNotify.onResponse(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyNotFull() {
        SubscribableListener<Void> toNotify;
        Object object = this.notFullLock;
        synchronized (object) {
            toNotify = this.notFullFuture;
            this.notFullFuture = null;
        }
        if (toNotify != null) {
            toNotify.onResponse(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    SubscribableListener<Void> waitForWriting() {
        if (this.queueSize.get() < this.maxSize || this.noMoreInputs) {
            return Operator.NOT_BLOCKED;
        }
        Object object = this.notFullLock;
        synchronized (object) {
            if (this.queueSize.get() < this.maxSize || this.noMoreInputs) {
                return Operator.NOT_BLOCKED;
            }
            if (this.notFullFuture == null) {
                this.notFullFuture = new SubscribableListener();
            }
            return this.notFullFuture;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    SubscribableListener<Void> waitForReading() {
        if (this.size() > 0 || this.noMoreInputs) {
            return Operator.NOT_BLOCKED;
        }
        Object object = this.notEmptyLock;
        synchronized (object) {
            if (this.size() > 0 || this.noMoreInputs) {
                return Operator.NOT_BLOCKED;
            }
            if (this.notEmptyFuture == null) {
                this.notEmptyFuture = new SubscribableListener();
            }
            return this.notEmptyFuture;
        }
    }

    private void discardPages() {
        Page p;
        while ((p = this.pollPage()) != null) {
            p.releaseBlocks();
        }
    }

    void finish(boolean drainingPages) {
        this.noMoreInputs = true;
        if (drainingPages) {
            this.discardPages();
        }
        this.notifyNotEmpty();
        if (drainingPages || this.queueSize.get() == 0) {
            this.completionFuture.onResponse(null);
        }
    }

    boolean isFinished() {
        return this.completionFuture.isDone();
    }

    boolean noMoreInputs() {
        return this.noMoreInputs;
    }

    int size() {
        return this.queueSize.get();
    }

    void addCompletionListener(ActionListener<Void> listener) {
        this.completionFuture.addListener(listener);
    }
}

