/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.lucene;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.function.IntFunction;
import java.util.function.Supplier;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.SortedDocValues;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BlockFactory;
import org.elasticsearch.compute.data.BytesRefBlock;
import org.elasticsearch.compute.data.DocBlock;
import org.elasticsearch.compute.data.DocVector;
import org.elasticsearch.compute.data.ElementType;
import org.elasticsearch.compute.data.IntVector;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.compute.data.SingletonOrdinalsBuilder;
import org.elasticsearch.compute.operator.AbstractPageMappingOperator;
import org.elasticsearch.compute.operator.DriverContext;
import org.elasticsearch.compute.operator.Operator;
import org.elasticsearch.core.Assertions;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.index.fieldvisitor.StoredFieldLoader;
import org.elasticsearch.index.mapper.BlockLoader;
import org.elasticsearch.index.mapper.BlockLoaderStoredFieldsFromLeafLoader;
import org.elasticsearch.index.mapper.SourceLoader;
import org.elasticsearch.search.fetch.StoredFieldsSpec;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;

public class ValuesSourceReaderOperator
extends AbstractPageMappingOperator {
    static final int SEQUENTIAL_BOUNDARY = 10;
    private final FieldWork[] fields;
    private final List<ShardContext> shardContexts;
    private final int docChannel;
    private final BlockFactory blockFactory;
    private final Map<String, Integer> readersBuilt = new TreeMap<String, Integer>();
    int lastShard = -1;
    int lastSegment = -1;

    public ValuesSourceReaderOperator(BlockFactory blockFactory, List<FieldInfo> fields, List<ShardContext> shardContexts, int docChannel) {
        this.fields = (FieldWork[])fields.stream().map(f -> new FieldWork((FieldInfo)f)).toArray(FieldWork[]::new);
        this.shardContexts = shardContexts;
        this.docChannel = docChannel;
        this.blockFactory = blockFactory;
    }

    @Override
    protected Page process(Page page) {
        DocVector docVector = ((DocBlock)page.getBlock(this.docChannel)).asVector();
        Releasable[] blocks = new Block[this.fields.length];
        boolean success = false;
        try {
            if (docVector.singleSegmentNonDecreasing()) {
                final IntVector docs = docVector.docs();
                int shard = docVector.shards().getInt(0);
                int segment = docVector.segments().getInt(0);
                this.loadFromSingleLeaf((Block[])blocks, shard, segment, new BlockLoader.Docs(){

                    public int count() {
                        return docs.getPositionCount();
                    }

                    public int get(int i) {
                        return docs.getInt(i);
                    }
                });
            } else if (docVector.singleSegment()) {
                this.loadFromSingleLeafUnsorted((Block[])blocks, docVector);
            } else {
                try (LoadFromMany many = new LoadFromMany((Block[])blocks, docVector);){
                    many.run();
                }
            }
            if (Assertions.ENABLED) {
                for (int f = 0; f < this.fields.length; ++f) {
                    assert (blocks[f].elementType() == ElementType.NULL || blocks[f].elementType() == this.fields[f].info.type) : blocks[f].elementType() + " NOT IN (NULL, " + this.fields[f].info.type + ")";
                }
            }
            success = true;
            Page f = page.appendBlocks((Block[])blocks);
            return f;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        finally {
            if (!success) {
                Releasables.closeExpectNoException((Releasable[])blocks);
            }
        }
    }

    private void positionFieldWork(int shard, int segment, int firstDoc) {
        if (this.lastShard == shard) {
            if (this.lastSegment == segment) {
                for (FieldWork w : this.fields) {
                    w.sameSegment(firstDoc);
                }
                return;
            }
            this.lastSegment = segment;
            for (FieldWork w : this.fields) {
                w.sameShardNewSegment();
            }
            return;
        }
        this.lastShard = shard;
        this.lastSegment = segment;
        for (FieldWork w : this.fields) {
            w.newShard(shard);
        }
    }

    private boolean positionFieldWorkDocGuarteedAscending(int shard, int segment) {
        if (this.lastShard == shard) {
            if (this.lastSegment == segment) {
                return false;
            }
            this.lastSegment = segment;
            for (FieldWork w : this.fields) {
                w.sameShardNewSegment();
            }
            return true;
        }
        this.lastShard = shard;
        this.lastSegment = segment;
        for (FieldWork w : this.fields) {
            w.newShard(shard);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadFromSingleLeaf(Block[] blocks, int shard, int segment, BlockLoader.Docs docs) throws IOException {
        int firstDoc = docs.get(0);
        this.positionFieldWork(shard, segment, firstDoc);
        StoredFieldsSpec storedFieldsSpec = StoredFieldsSpec.NO_REQUIREMENTS;
        ArrayList<RowStrideReaderWork> rowStrideReaders = new ArrayList<RowStrideReaderWork>(this.fields.length);
        ComputeBlockLoaderFactory loaderBlockFactory = new ComputeBlockLoaderFactory(this.blockFactory, docs.count());
        LeafReaderContext ctx = this.ctx(shard, segment);
        try {
            StoredFieldLoader storedFieldLoader;
            for (int f = 0; f < this.fields.length; ++f) {
                FieldWork field = this.fields[f];
                BlockLoader.ColumnAtATimeReader columnAtATime = field.columnAtATime(ctx);
                if (columnAtATime != null) {
                    blocks[f] = (Block)columnAtATime.read((BlockLoader.BlockFactory)loaderBlockFactory, docs);
                    continue;
                }
                rowStrideReaders.add(new RowStrideReaderWork(field.rowStride(ctx), (Block.Builder)field.loader.builder((BlockLoader.BlockFactory)loaderBlockFactory, docs.count()), field.loader, f));
                storedFieldsSpec = storedFieldsSpec.merge(field.loader.rowStrideStoredFieldSpec());
            }
            if (rowStrideReaders.isEmpty()) {
                return;
            }
            if (storedFieldsSpec.equals((Object)StoredFieldsSpec.NO_REQUIREMENTS)) {
                throw new IllegalStateException("found row stride readers [" + rowStrideReaders + "] without stored fields [" + storedFieldsSpec + "]");
            }
            if (this.useSequentialStoredFieldsReader(docs)) {
                storedFieldLoader = StoredFieldLoader.fromSpecSequential((StoredFieldsSpec)storedFieldsSpec);
                this.trackStoredFields(storedFieldsSpec, true);
            } else {
                storedFieldLoader = StoredFieldLoader.fromSpec((StoredFieldsSpec)storedFieldsSpec);
                this.trackStoredFields(storedFieldsSpec, false);
            }
            BlockLoaderStoredFieldsFromLeafLoader storedFields = new BlockLoaderStoredFieldsFromLeafLoader(storedFieldLoader.getLoader(ctx, null), storedFieldsSpec.requiresSource() ? this.shardContexts.get((int)shard).newSourceLoader.get().leaf(ctx.reader(), null) : null);
            for (int p = 0; p < docs.count(); ++p) {
                int doc = docs.get(p);
                storedFields.advanceTo(doc);
                for (RowStrideReaderWork work : rowStrideReaders) {
                    work.read(doc, storedFields);
                }
            }
            for (RowStrideReaderWork work : rowStrideReaders) {
                blocks[work.offset] = work.build();
            }
        }
        finally {
            Releasables.close(rowStrideReaders);
        }
    }

    private void loadFromSingleLeafUnsorted(Block[] blocks, DocVector docVector) throws IOException {
        final IntVector docs = docVector.docs();
        final int[] forwards = docVector.shardSegmentDocMapForwards();
        int shard = docVector.shards().getInt(0);
        int segment = docVector.segments().getInt(0);
        this.loadFromSingleLeaf(blocks, shard, segment, new BlockLoader.Docs(){

            public int count() {
                return docs.getPositionCount();
            }

            public int get(int i) {
                return docs.getInt(forwards[i]);
            }
        });
        int[] backwards = docVector.shardSegmentDocMapBackwards();
        for (int i = 0; i < blocks.length; ++i) {
            Block in = blocks[i];
            blocks[i] = in.filter(backwards);
            in.close();
        }
    }

    private boolean useSequentialStoredFieldsReader(BlockLoader.Docs docs) {
        int count = docs.count();
        return count >= 10 && docs.get(count - 1) - docs.get(0) == count - 1;
    }

    private void trackStoredFields(StoredFieldsSpec spec, boolean sequential) {
        this.readersBuilt.merge("stored_fields[requires_source:" + spec.requiresSource() + ", fields:" + spec.requiredStoredFields().size() + ", sequential: " + sequential + "]", 1, (prev, one) -> prev + one);
    }

    private LeafReaderContext ctx(int shard, int segment) {
        return (LeafReaderContext)this.shardContexts.get((int)shard).reader.leaves().get(segment);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("ValuesSourceReaderOperator[fields = [");
        if (this.fields.length < 10) {
            boolean first = true;
            for (FieldWork f : this.fields) {
                if (first) {
                    first = false;
                } else {
                    sb.append(", ");
                }
                sb.append(f.info.name);
            }
        } else {
            sb.append(this.fields.length).append(" fields");
        }
        return sb.append("]]").toString();
    }

    @Override
    protected Status status(long processNanos, int pagesProcessed) {
        return new Status(new TreeMap<String, Integer>(this.readersBuilt), processNanos, pagesProcessed);
    }

    private class FieldWork {
        final FieldInfo info;
        BlockLoader loader;
        BlockLoader.ColumnAtATimeReader columnAtATime;
        BlockLoader.RowStrideReader rowStride;

        FieldWork(FieldInfo info) {
            this.info = info;
        }

        void sameSegment(int firstDoc) {
            if (this.columnAtATime != null && !this.columnAtATime.canReuse(firstDoc)) {
                this.columnAtATime = null;
            }
            if (this.rowStride != null && !this.rowStride.canReuse(firstDoc)) {
                this.rowStride = null;
            }
        }

        void sameShardNewSegment() {
            this.columnAtATime = null;
            this.rowStride = null;
        }

        void newShard(int shard) {
            this.loader = this.info.blockLoader.apply(shard);
            this.columnAtATime = null;
            this.rowStride = null;
        }

        BlockLoader.ColumnAtATimeReader columnAtATime(LeafReaderContext ctx) throws IOException {
            if (this.columnAtATime == null) {
                this.columnAtATime = this.loader.columnAtATimeReader(ctx);
                this.trackReader("column_at_a_time", (BlockLoader.Reader)this.columnAtATime);
            }
            return this.columnAtATime;
        }

        BlockLoader.RowStrideReader rowStride(LeafReaderContext ctx) throws IOException {
            if (this.rowStride == null) {
                this.rowStride = this.loader.rowStrideReader(ctx);
                this.trackReader("row_stride", (BlockLoader.Reader)this.rowStride);
            }
            return this.rowStride;
        }

        private void trackReader(String type, BlockLoader.Reader reader) {
            ValuesSourceReaderOperator.this.readersBuilt.merge(this.info.name + ":" + type + ":" + reader, 1, (prev, one) -> prev + one);
        }
    }

    private class LoadFromMany
    implements Releasable {
        private final Block[] target;
        private final IntVector shards;
        private final IntVector segments;
        private final IntVector docs;
        private final int[] forwards;
        private final int[] backwards;
        private final Block.Builder[][] builders;
        private final BlockLoader[][] converters;
        private final Block.Builder[] fieldTypeBuilders;
        private final BlockLoader.RowStrideReader[] rowStride;
        BlockLoaderStoredFieldsFromLeafLoader storedFields;

        LoadFromMany(Block[] target, DocVector docVector) {
            this.target = target;
            this.shards = docVector.shards();
            this.segments = docVector.segments();
            this.docs = docVector.docs();
            this.forwards = docVector.shardSegmentDocMapForwards();
            this.backwards = docVector.shardSegmentDocMapBackwards();
            this.fieldTypeBuilders = new Block.Builder[target.length];
            this.builders = new Block.Builder[target.length][ValuesSourceReaderOperator.this.shardContexts.size()];
            this.converters = new BlockLoader[target.length][ValuesSourceReaderOperator.this.shardContexts.size()];
            this.rowStride = new BlockLoader.RowStrideReader[target.length];
        }

        void run() throws IOException {
            for (int f = 0; f < ValuesSourceReaderOperator.this.fields.length; ++f) {
                this.fieldTypeBuilders[f] = ValuesSourceReaderOperator.this.fields[f].info.type.newBlockBuilder(this.docs.getPositionCount(), ValuesSourceReaderOperator.this.blockFactory);
                this.builders[f] = new Block.Builder[ValuesSourceReaderOperator.this.shardContexts.size()];
                this.converters[f] = new BlockLoader[ValuesSourceReaderOperator.this.shardContexts.size()];
            }
            ComputeBlockLoaderFactory loaderBlockFactory = new ComputeBlockLoaderFactory(ValuesSourceReaderOperator.this.blockFactory, this.docs.getPositionCount());
            int p = this.forwards[0];
            int shard = this.shards.getInt(p);
            int segment = this.segments.getInt(p);
            int firstDoc = this.docs.getInt(p);
            ValuesSourceReaderOperator.this.positionFieldWork(shard, segment, firstDoc);
            LeafReaderContext ctx = ValuesSourceReaderOperator.this.ctx(shard, segment);
            this.fieldsMoved(ctx, shard);
            this.verifyBuilders(loaderBlockFactory, shard);
            this.read(firstDoc, shard);
            for (int i = 1; i < this.forwards.length; ++i) {
                p = this.forwards[i];
                shard = this.shards.getInt(p);
                boolean changedSegment = ValuesSourceReaderOperator.this.positionFieldWorkDocGuarteedAscending(shard, segment = this.segments.getInt(p));
                if (changedSegment) {
                    ctx = ValuesSourceReaderOperator.this.ctx(shard, segment);
                    this.fieldsMoved(ctx, shard);
                }
                this.verifyBuilders(loaderBlockFactory, shard);
                this.read(this.docs.getInt(p), shard);
            }
            for (int f = 0; f < this.target.length; ++f) {
                for (int s = 0; s < ValuesSourceReaderOperator.this.shardContexts.size(); ++s) {
                    if (this.builders[f][s] == null) continue;
                    try (Block orig = (Block)this.converters[f][s].convert((BlockLoader.Block)this.builders[f][s].build());){
                        this.fieldTypeBuilders[f].copyFrom(orig, 0, orig.getPositionCount());
                        continue;
                    }
                }
                try (Block targetBlock = this.fieldTypeBuilders[f].build();){
                    this.target[f] = targetBlock.filter(this.backwards);
                    continue;
                }
            }
        }

        private void fieldsMoved(LeafReaderContext ctx, int shard) throws IOException {
            StoredFieldsSpec storedFieldsSpec = StoredFieldsSpec.NO_REQUIREMENTS;
            for (int f = 0; f < ValuesSourceReaderOperator.this.fields.length; ++f) {
                FieldWork field = ValuesSourceReaderOperator.this.fields[f];
                this.rowStride[f] = field.rowStride(ctx);
                storedFieldsSpec = storedFieldsSpec.merge(field.loader.rowStrideStoredFieldSpec());
                this.storedFields = new BlockLoaderStoredFieldsFromLeafLoader(StoredFieldLoader.fromSpec((StoredFieldsSpec)storedFieldsSpec).getLoader(ctx, null), storedFieldsSpec.requiresSource() ? ValuesSourceReaderOperator.this.shardContexts.get((int)shard).newSourceLoader.get().leaf(ctx.reader(), null) : null);
                if (storedFieldsSpec.equals((Object)StoredFieldsSpec.NO_REQUIREMENTS)) continue;
                ValuesSourceReaderOperator.this.trackStoredFields(storedFieldsSpec, false);
            }
        }

        private void verifyBuilders(ComputeBlockLoaderFactory loaderBlockFactory, int shard) {
            for (int f = 0; f < ValuesSourceReaderOperator.this.fields.length; ++f) {
                if (this.builders[f][shard] != null) continue;
                this.builders[f][shard] = (Block.Builder)ValuesSourceReaderOperator.this.fields[f].loader.builder((BlockLoader.BlockFactory)loaderBlockFactory, this.docs.getPositionCount());
                this.converters[f][shard] = ValuesSourceReaderOperator.this.fields[f].loader;
            }
        }

        private void read(int doc, int shard) throws IOException {
            this.storedFields.advanceTo(doc);
            for (int f = 0; f < this.builders.length; ++f) {
                this.rowStride[f].read(doc, (BlockLoader.StoredFields)this.storedFields, (BlockLoader.Builder)this.builders[f][shard]);
            }
        }

        public void close() {
            Releasables.closeExpectNoException((Releasable[])this.fieldTypeBuilders);
            for (int f = 0; f < ValuesSourceReaderOperator.this.fields.length; ++f) {
                Releasables.closeExpectNoException((Releasable[])this.builders[f]);
            }
        }
    }

    public record FieldInfo(String name, ElementType type, IntFunction<BlockLoader> blockLoader) {
    }

    private static class ComputeBlockLoaderFactory
    implements BlockLoader.BlockFactory {
        private final BlockFactory factory;
        private final int pageSize;
        private Block nullBlock;

        private ComputeBlockLoaderFactory(BlockFactory factory, int pageSize) {
            this.factory = factory;
            this.pageSize = pageSize;
        }

        public BlockLoader.BooleanBuilder booleansFromDocValues(int expectedCount) {
            return this.factory.newBooleanBlockBuilder(expectedCount).mvOrdering(Block.MvOrdering.SORTED_ASCENDING);
        }

        public BlockLoader.BooleanBuilder booleans(int expectedCount) {
            return this.factory.newBooleanBlockBuilder(expectedCount);
        }

        public BlockLoader.BytesRefBuilder bytesRefsFromDocValues(int expectedCount) {
            return this.factory.newBytesRefBlockBuilder(expectedCount).mvOrdering(Block.MvOrdering.DEDUPLICATED_AND_SORTED_ASCENDING);
        }

        public BlockLoader.BytesRefBuilder bytesRefs(int expectedCount) {
            return this.factory.newBytesRefBlockBuilder(expectedCount);
        }

        public BlockLoader.DoubleBuilder doublesFromDocValues(int expectedCount) {
            return this.factory.newDoubleBlockBuilder(expectedCount).mvOrdering(Block.MvOrdering.SORTED_ASCENDING);
        }

        public BlockLoader.DoubleBuilder doubles(int expectedCount) {
            return this.factory.newDoubleBlockBuilder(expectedCount);
        }

        public BlockLoader.IntBuilder intsFromDocValues(int expectedCount) {
            return this.factory.newIntBlockBuilder(expectedCount).mvOrdering(Block.MvOrdering.SORTED_ASCENDING);
        }

        public BlockLoader.IntBuilder ints(int expectedCount) {
            return this.factory.newIntBlockBuilder(expectedCount);
        }

        public BlockLoader.LongBuilder longsFromDocValues(int expectedCount) {
            return this.factory.newLongBlockBuilder(expectedCount).mvOrdering(Block.MvOrdering.SORTED_ASCENDING);
        }

        public BlockLoader.LongBuilder longs(int expectedCount) {
            return this.factory.newLongBlockBuilder(expectedCount);
        }

        public BlockLoader.Builder nulls(int expectedCount) {
            return ElementType.NULL.newBlockBuilder(expectedCount, this.factory);
        }

        public Block constantNulls() {
            if (this.nullBlock == null) {
                this.nullBlock = this.factory.newConstantNullBlock(this.pageSize);
            } else {
                this.nullBlock.incRef();
            }
            return this.nullBlock;
        }

        public BytesRefBlock constantBytes(BytesRef value) {
            return this.factory.newConstantBytesRefBlockWith(value, this.pageSize);
        }

        public BlockLoader.SingletonOrdinalsBuilder singletonOrdinalsBuilder(SortedDocValues ordinals, int count) {
            return new SingletonOrdinalsBuilder(this.factory, ordinals, count);
        }
    }

    private record RowStrideReaderWork(BlockLoader.RowStrideReader reader, Block.Builder builder, BlockLoader loader, int offset) implements Releasable
    {
        void read(int doc, BlockLoaderStoredFieldsFromLeafLoader storedFields) throws IOException {
            this.reader.read(doc, (BlockLoader.StoredFields)storedFields, (BlockLoader.Builder)this.builder);
        }

        Block build() {
            return (Block)this.loader.convert((BlockLoader.Block)this.builder.build());
        }

        public void close() {
            this.builder.close();
        }
    }

    public record ShardContext(IndexReader reader, Supplier<SourceLoader> newSourceLoader) {
    }

    public static class Status
    extends AbstractPageMappingOperator.Status {
        public static final NamedWriteableRegistry.Entry ENTRY = new NamedWriteableRegistry.Entry(Operator.Status.class, "values_source_reader", Status::new);
        private final Map<String, Integer> readersBuilt;

        Status(Map<String, Integer> readersBuilt, long processNanos, int pagesProcessed) {
            super(processNanos, pagesProcessed);
            this.readersBuilt = readersBuilt;
        }

        Status(StreamInput in) throws IOException {
            super(in);
            this.readersBuilt = in.readOrderedMap(StreamInput::readString, StreamInput::readVInt);
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeMap(this.readersBuilt, StreamOutput::writeVInt);
        }

        @Override
        public String getWriteableName() {
            return Status.ENTRY.name;
        }

        public Map<String, Integer> readersBuilt() {
            return this.readersBuilt;
        }

        @Override
        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.startObject("readers_built");
            for (Map.Entry<String, Integer> e : this.readersBuilt.entrySet()) {
                builder.field(e.getKey(), e.getValue());
            }
            builder.endObject();
            this.innerToXContent(builder);
            return builder.endObject();
        }

        @Override
        public boolean equals(Object o) {
            if (!super.equals(o)) {
                return false;
            }
            Status status = (Status)o;
            return this.readersBuilt.equals(status.readersBuilt);
        }

        @Override
        public int hashCode() {
            return Objects.hash(super.hashCode(), this.readersBuilt);
        }

        @Override
        public String toString() {
            return Strings.toString((ToXContent)this);
        }
    }

    public record Factory(List<FieldInfo> fields, List<ShardContext> shardContexts, int docChannel) implements Operator.OperatorFactory
    {
        @Override
        public Operator get(DriverContext driverContext) {
            return new ValuesSourceReaderOperator(driverContext.blockFactory(), this.fields, this.shardContexts, this.docChannel);
        }

        @Override
        public String describe() {
            StringBuilder sb = new StringBuilder();
            sb.append("ValuesSourceReaderOperator[fields = [");
            if (this.fields.size() < 10) {
                boolean first = true;
                for (FieldInfo f : this.fields) {
                    if (first) {
                        first = false;
                    } else {
                        sb.append(", ");
                    }
                    sb.append(f.name);
                }
            } else {
                sb.append(this.fields.size()).append(" fields");
            }
            return sb.append("]]").toString();
        }
    }
}

