/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.lucene;

import java.io.IOException;
import java.util.function.Function;
import org.apache.lucene.index.LeafReaderContext;
import org.elasticsearch.common.Rounding;
import org.elasticsearch.index.fielddata.DocValueBits;
import org.elasticsearch.index.fielddata.FieldData;
import org.elasticsearch.index.fielddata.SortedBinaryDocValues;
import org.elasticsearch.search.aggregations.support.AggregationContext;
import org.elasticsearch.search.aggregations.support.ValuesSource;

public class UnsupportedValueSource
extends ValuesSource {
    public static final String UNSUPPORTED_OUTPUT = null;
    private final ValuesSource originalSource;

    public UnsupportedValueSource(ValuesSource originalSource) {
        this.originalSource = originalSource;
    }

    public SortedBinaryDocValues bytesValues(LeafReaderContext context) throws IOException {
        if (this.originalSource != null) {
            try {
                return this.originalSource.bytesValues(context);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return FieldData.emptySortedBinary();
    }

    public DocValueBits docsWithValue(LeafReaderContext context) throws IOException {
        throw new UnsupportedOperationException();
    }

    protected Function<Rounding, Rounding.Prepared> roundingPreparer(AggregationContext context) throws IOException {
        throw new UnsupportedOperationException();
    }
}

