/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.data;

import java.io.IOException;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.common.VersionId;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BlockStreamInput;
import org.elasticsearch.compute.data.IntBlock;
import org.elasticsearch.compute.data.LongArrayBlock;
import org.elasticsearch.compute.data.LongBigArrayBlock;
import org.elasticsearch.compute.data.LongVector;
import org.elasticsearch.core.ReleasableIterator;
import org.elasticsearch.index.mapper.BlockLoader;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface LongBlock
extends Block {
    public static final NamedWriteableRegistry.Entry ENTRY;

    public long getLong(int var1);

    @Override
    public LongVector asVector();

    @Override
    public LongBlock filter(int ... var1);

    public ReleasableIterator<? extends LongBlock> lookup(IntBlock var1, ByteSizeValue var2);

    @Override
    public LongBlock expand();

    default public String getWriteableName() {
        return "LongBlock";
    }

    private static LongBlock readFrom(StreamInput in) throws IOException {
        return LongBlock.readFrom((BlockStreamInput)in);
    }

    public static LongBlock readFrom(BlockStreamInput in) throws IOException {
        byte serializationType = in.readByte();
        return switch (serializationType) {
            case 0 -> LongBlock.readValues(in);
            case 1 -> LongVector.readFrom(in.blockFactory(), (StreamInput)in).asBlock();
            case 2 -> LongArrayBlock.readArrayBlock(in.blockFactory(), in);
            case 3 -> LongBigArrayBlock.readArrayBlock(in.blockFactory(), in);
            default -> {
                if (!1.$assertionsDisabled) {
                    throw new AssertionError((Object)("invalid block serialization type " + serializationType));
                }
                throw new IllegalStateException("invalid serialization type " + serializationType);
            }
        };
    }

    private static LongBlock readValues(BlockStreamInput in) throws IOException {
        int positions = in.readVInt();
        try (Builder builder = in.blockFactory().newLongBlockBuilder(positions);){
            for (int i = 0; i < positions; ++i) {
                if (in.readBoolean()) {
                    builder.appendNull();
                    continue;
                }
                int valueCount = in.readVInt();
                builder.beginPositionEntry();
                for (int valueIndex = 0; valueIndex < valueCount; ++valueIndex) {
                    builder.appendLong(in.readLong());
                }
                builder.endPositionEntry();
            }
            LongBlock longBlock = builder.build();
            return longBlock;
        }
    }

    default public void writeTo(StreamOutput out) throws IOException {
        LongBlock longBlock;
        LongVector vector = this.asVector();
        TransportVersion version = out.getTransportVersion();
        if (vector != null) {
            out.writeByte((byte)1);
            vector.writeTo(out);
        } else if (version.onOrAfter((VersionId)TransportVersions.ESQL_SERIALIZE_ARRAY_BLOCK) && (longBlock = this) instanceof LongArrayBlock) {
            LongArrayBlock b = (LongArrayBlock)longBlock;
            out.writeByte((byte)2);
            b.writeArrayBlock(out);
        } else if (version.onOrAfter((VersionId)TransportVersions.ESQL_SERIALIZE_BIG_ARRAY) && (longBlock = this) instanceof LongBigArrayBlock) {
            LongBigArrayBlock b = (LongBigArrayBlock)longBlock;
            out.writeByte((byte)3);
            b.writeArrayBlock(out);
        } else {
            out.writeByte((byte)0);
            LongBlock.writeValues(this, out);
        }
    }

    private static void writeValues(LongBlock block, StreamOutput out) throws IOException {
        int positions = block.getPositionCount();
        out.writeVInt(positions);
        for (int pos = 0; pos < positions; ++pos) {
            if (block.isNull(pos)) {
                out.writeBoolean(true);
                continue;
            }
            out.writeBoolean(false);
            int valueCount = block.getValueCount(pos);
            out.writeVInt(valueCount);
            for (int valueIndex = 0; valueIndex < valueCount; ++valueIndex) {
                out.writeLong(block.getLong(block.getFirstValueIndex(pos) + valueIndex));
            }
        }
    }

    public boolean equals(Object var1);

    public int hashCode();

    public static boolean equals(LongBlock block1, LongBlock block2) {
        if (block1 == block2) {
            return true;
        }
        int positions = block1.getPositionCount();
        if (positions != block2.getPositionCount()) {
            return false;
        }
        for (int pos = 0; pos < positions; ++pos) {
            if (block1.isNull(pos) || block2.isNull(pos)) {
                if (block1.isNull(pos) == block2.isNull(pos)) continue;
                return false;
            }
            int valueCount = block1.getValueCount(pos);
            if (valueCount != block2.getValueCount(pos)) {
                return false;
            }
            int b1ValueIdx = block1.getFirstValueIndex(pos);
            int b2ValueIdx = block2.getFirstValueIndex(pos);
            for (int valueIndex = 0; valueIndex < valueCount; ++valueIndex) {
                if (block1.getLong(b1ValueIdx + valueIndex) == block2.getLong(b2ValueIdx + valueIndex)) continue;
                return false;
            }
        }
        return true;
    }

    public static int hash(LongBlock block) {
        int positions = block.getPositionCount();
        int result = 1;
        for (int pos = 0; pos < positions; ++pos) {
            if (block.isNull(pos)) {
                result = 31 * result - 1;
                continue;
            }
            int valueCount = block.getValueCount(pos);
            result = 31 * result + valueCount;
            int firstValueIdx = block.getFirstValueIndex(pos);
            for (int valueIndex = 0; valueIndex < valueCount; ++valueIndex) {
                long element = block.getLong(firstValueIdx + valueIndex);
                result = 31 * result + (int)(element ^ element >>> 32);
            }
        }
        return result;
    }

    static {
        if (1.$assertionsDisabled) {
            // empty if block
        }
        ENTRY = new NamedWriteableRegistry.Entry(Block.class, "LongBlock", LongBlock::readFrom);
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static interface Builder
    extends Block.Builder,
    BlockLoader.LongBuilder {
        public Builder appendLong(long var1);

        public Builder copyFrom(LongBlock var1, int var2, int var3);

        @Override
        public Builder appendNull();

        @Override
        public Builder beginPositionEntry();

        @Override
        public Builder endPositionEntry();

        @Override
        public Builder copyFrom(Block var1, int var2, int var3);

        @Override
        public Builder mvOrdering(Block.MvOrdering var1);

        @Override
        public LongBlock build();
    }
}

