/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.data;

import java.io.IOException;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.common.VersionId;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.compute.data.BlockFactory;
import org.elasticsearch.compute.data.IntArrayVector;
import org.elasticsearch.compute.data.IntBigArrayVector;
import org.elasticsearch.compute.data.IntBlock;
import org.elasticsearch.compute.data.Vector;
import org.elasticsearch.core.ReleasableIterator;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface IntVector
extends Vector {
    public int getInt(int var1);

    @Override
    public IntBlock asBlock();

    @Override
    public IntVector filter(int ... var1);

    public ReleasableIterator<? extends IntBlock> lookup(IntBlock var1, ByteSizeValue var2);

    public int min();

    public int max();

    public boolean equals(Object var1);

    public int hashCode();

    public static boolean equals(IntVector vector1, IntVector vector2) {
        int positions = vector1.getPositionCount();
        if (positions != vector2.getPositionCount()) {
            return false;
        }
        for (int pos = 0; pos < positions; ++pos) {
            if (vector1.getInt(pos) == vector2.getInt(pos)) continue;
            return false;
        }
        return true;
    }

    public static int hash(IntVector vector) {
        int len = vector.getPositionCount();
        int result = 1;
        for (int pos = 0; pos < len; ++pos) {
            result = 31 * result + vector.getInt(pos);
        }
        return result;
    }

    public static IntVector readFrom(BlockFactory blockFactory, StreamInput in) throws IOException {
        int positions = in.readVInt();
        byte serializationType = in.readByte();
        return switch (serializationType) {
            case 0 -> IntVector.readValues(positions, in, blockFactory);
            case 1 -> blockFactory.newConstantIntVector(in.readInt(), positions);
            case 2 -> IntArrayVector.readArrayVector(positions, in, blockFactory);
            case 3 -> IntBigArrayVector.readArrayVector(positions, in, blockFactory);
            default -> {
                if (!1.$assertionsDisabled) {
                    throw new AssertionError((Object)("invalid vector serialization type [" + serializationType + "]"));
                }
                throw new IllegalStateException("invalid vector serialization type [" + serializationType + "]");
            }
        };
    }

    default public void writeTo(StreamOutput out) throws IOException {
        IntVector intVector;
        int positions = this.getPositionCount();
        TransportVersion version = out.getTransportVersion();
        out.writeVInt(positions);
        if (this.isConstant() && positions > 0) {
            out.writeByte((byte)1);
            out.writeInt(this.getInt(0));
        } else if (version.onOrAfter((VersionId)TransportVersions.ESQL_SERIALIZE_ARRAY_VECTOR) && (intVector = this) instanceof IntArrayVector) {
            IntArrayVector v = (IntArrayVector)intVector;
            out.writeByte((byte)2);
            v.writeArrayVector(positions, out);
        } else if (version.onOrAfter((VersionId)TransportVersions.ESQL_SERIALIZE_BIG_VECTOR) && (intVector = this) instanceof IntBigArrayVector) {
            IntBigArrayVector v = (IntBigArrayVector)intVector;
            out.writeByte((byte)3);
            v.writeArrayVector(positions, out);
        } else {
            out.writeByte((byte)0);
            IntVector.writeValues(this, positions, out);
        }
    }

    private static IntVector readValues(int positions, StreamInput in, BlockFactory blockFactory) throws IOException {
        try (FixedBuilder builder = blockFactory.newIntVectorFixedBuilder(positions);){
            for (int i = 0; i < positions; ++i) {
                builder.appendInt(i, in.readInt());
            }
            IntVector intVector = builder.build();
            return intVector;
        }
    }

    private static void writeValues(IntVector v, int positions, StreamOutput out) throws IOException {
        for (int i = 0; i < positions; ++i) {
            out.writeInt(v.getInt(i));
        }
    }

    public static IntVector range(int startInclusive, int endExclusive, BlockFactory blockFactory) {
        int[] values = new int[endExclusive - startInclusive];
        for (int i = 0; i < values.length; ++i) {
            values[i] = startInclusive + i;
        }
        return blockFactory.newIntArrayVector(values, values.length);
    }

    static {
        if (1.$assertionsDisabled) {
            // empty if block
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static interface FixedBuilder
    extends Builder {
        @Override
        public FixedBuilder appendInt(int var1);

        public FixedBuilder appendInt(int var1, int var2);
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static interface Builder
    extends Vector.Builder {
        public Builder appendInt(int var1);

        @Override
        public IntVector build();
    }
}

