/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.data;

import java.io.IOException;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.lucene.util.RamUsageEstimator;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.compute.data.AbstractVector;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BlockFactory;
import org.elasticsearch.compute.data.ElementType;
import org.elasticsearch.compute.data.IntBlock;
import org.elasticsearch.compute.data.IntLookup;
import org.elasticsearch.compute.data.IntVector;
import org.elasticsearch.compute.data.IntVectorBlock;
import org.elasticsearch.core.ReleasableIterator;

final class IntArrayVector
extends AbstractVector
implements IntVector {
    static final long BASE_RAM_BYTES_USED = RamUsageEstimator.shallowSizeOfInstance(IntArrayVector.class) + RamUsageEstimator.shallowSizeOfInstance(IntVectorBlock.class) + (long)Block.PAGE_MEM_OVERHEAD_PER_BLOCK;
    private final int[] values;
    private Integer min;
    private Integer max;

    IntArrayVector(int[] values, int positionCount, BlockFactory blockFactory) {
        super(positionCount, blockFactory);
        this.values = values;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static IntArrayVector readArrayVector(int positions, StreamInput in, BlockFactory blockFactory) throws IOException {
        long preAdjustedBytes = (long)RamUsageEstimator.NUM_BYTES_ARRAY_HEADER + (long)positions * 4L;
        blockFactory.adjustBreaker(preAdjustedBytes);
        boolean success = false;
        try {
            int[] values = new int[positions];
            for (int i = 0; i < positions; ++i) {
                values[i] = in.readInt();
            }
            IntArrayVector block = new IntArrayVector(values, positions, blockFactory);
            blockFactory.adjustBreaker(block.ramBytesUsed() - preAdjustedBytes);
            success = true;
            IntArrayVector intArrayVector = block;
            return intArrayVector;
        }
        finally {
            if (!success) {
                blockFactory.adjustBreaker(-preAdjustedBytes);
            }
        }
    }

    void writeArrayVector(int positions, StreamOutput out) throws IOException {
        for (int i = 0; i < positions; ++i) {
            out.writeInt(this.values[i]);
        }
    }

    @Override
    public IntBlock asBlock() {
        return new IntVectorBlock(this);
    }

    @Override
    public int getInt(int position) {
        return this.values[position];
    }

    @Override
    public ElementType elementType() {
        return ElementType.INT;
    }

    @Override
    public boolean isConstant() {
        return false;
    }

    @Override
    public IntVector filter(int ... positions) {
        try (IntVector.Builder builder = this.blockFactory().newIntVectorBuilder(positions.length);){
            for (int pos : positions) {
                builder.appendInt(this.values[pos]);
            }
            IntVector intVector = builder.build();
            return intVector;
        }
    }

    public ReleasableIterator<IntBlock> lookup(IntBlock positions, ByteSizeValue targetBlockSize) {
        return new IntLookup(this.asBlock(), positions, targetBlockSize);
    }

    public static long ramBytesEstimated(int[] values) {
        return BASE_RAM_BYTES_USED + RamUsageEstimator.sizeOf((int[])values);
    }

    @Override
    public int min() {
        if (this.min == null) {
            int v = Integer.MAX_VALUE;
            for (int i = 0; i < this.getPositionCount(); ++i) {
                v = Math.min(v, this.values[i]);
            }
            this.min = v;
        }
        return this.min;
    }

    @Override
    public int max() {
        if (this.max == null) {
            int v = Integer.MIN_VALUE;
            for (int i = 0; i < this.getPositionCount(); ++i) {
                v = Math.max(v, this.values[i]);
            }
            this.max = v;
        }
        return this.max;
    }

    public long ramBytesUsed() {
        return IntArrayVector.ramBytesEstimated(this.values);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof IntVector) {
            IntVector that = (IntVector)obj;
            return IntVector.equals(this, that);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return IntVector.hash(this);
    }

    public String toString() {
        String valuesString = IntStream.range(0, this.getPositionCount()).limit(10L).mapToObj(n -> String.valueOf(this.values[n])).collect(Collectors.joining(", ", "[", this.getPositionCount() > 10 ? ", ...]" : "]"));
        return this.getClass().getSimpleName() + "[positions=" + this.getPositionCount() + ", values=" + valuesString + "]";
    }
}

