/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.data;

import java.io.IOException;
import org.apache.lucene.util.Accountable;
import org.apache.lucene.util.RamUsageEstimator;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.util.FloatArray;
import org.elasticsearch.compute.data.AbstractVector;
import org.elasticsearch.compute.data.BlockFactory;
import org.elasticsearch.compute.data.ElementType;
import org.elasticsearch.compute.data.FloatBlock;
import org.elasticsearch.compute.data.FloatLookup;
import org.elasticsearch.compute.data.FloatVector;
import org.elasticsearch.compute.data.FloatVectorBlock;
import org.elasticsearch.compute.data.IntBlock;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.ReleasableIterator;

public final class FloatBigArrayVector
extends AbstractVector
implements FloatVector,
Releasable {
    private static final long BASE_RAM_BYTES_USED = 0L;
    private final FloatArray values;

    public FloatBigArrayVector(FloatArray values, int positionCount, BlockFactory blockFactory) {
        super(positionCount, blockFactory);
        this.values = values;
    }

    static FloatBigArrayVector readArrayVector(int positions, StreamInput in, BlockFactory blockFactory) throws IOException {
        throw new UnsupportedOperationException();
    }

    void writeArrayVector(int positions, StreamOutput out) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public FloatBlock asBlock() {
        return new FloatVectorBlock(this);
    }

    @Override
    public float getFloat(int position) {
        return this.values.get((long)position);
    }

    @Override
    public ElementType elementType() {
        return ElementType.FLOAT;
    }

    @Override
    public boolean isConstant() {
        return false;
    }

    public long ramBytesUsed() {
        return 0L + RamUsageEstimator.sizeOf((Accountable)this.values);
    }

    @Override
    public FloatVector filter(int ... positions) {
        BlockFactory blockFactory = this.blockFactory();
        FloatArray filtered = blockFactory.bigArrays().newFloatArray((long)positions.length);
        for (int i = 0; i < positions.length; ++i) {
            filtered.set((long)i, this.values.get((long)positions[i]));
        }
        return new FloatBigArrayVector(filtered, positions.length, blockFactory);
    }

    public ReleasableIterator<FloatBlock> lookup(IntBlock positions, ByteSizeValue targetBlockSize) {
        return new FloatLookup(this.asBlock(), positions, targetBlockSize);
    }

    @Override
    public void closeInternal() {
        this.values.close();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof FloatVector) {
            FloatVector that = (FloatVector)obj;
            return FloatVector.equals(this, that);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return FloatVector.hash(this);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[positions=" + this.getPositionCount() + ", values=" + this.values + "]";
    }
}

