/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.data;

import java.io.IOException;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.lucene.util.RamUsageEstimator;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.compute.data.AbstractVector;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BlockFactory;
import org.elasticsearch.compute.data.DoubleBlock;
import org.elasticsearch.compute.data.DoubleLookup;
import org.elasticsearch.compute.data.DoubleVector;
import org.elasticsearch.compute.data.DoubleVectorBlock;
import org.elasticsearch.compute.data.ElementType;
import org.elasticsearch.compute.data.IntBlock;
import org.elasticsearch.core.ReleasableIterator;

final class DoubleArrayVector
extends AbstractVector
implements DoubleVector {
    static final long BASE_RAM_BYTES_USED = RamUsageEstimator.shallowSizeOfInstance(DoubleArrayVector.class) + RamUsageEstimator.shallowSizeOfInstance(DoubleVectorBlock.class) + (long)Block.PAGE_MEM_OVERHEAD_PER_BLOCK;
    private final double[] values;

    DoubleArrayVector(double[] values, int positionCount, BlockFactory blockFactory) {
        super(positionCount, blockFactory);
        this.values = values;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static DoubleArrayVector readArrayVector(int positions, StreamInput in, BlockFactory blockFactory) throws IOException {
        long preAdjustedBytes = (long)RamUsageEstimator.NUM_BYTES_ARRAY_HEADER + (long)positions * 8L;
        blockFactory.adjustBreaker(preAdjustedBytes);
        boolean success = false;
        try {
            double[] values = new double[positions];
            for (int i = 0; i < positions; ++i) {
                values[i] = in.readDouble();
            }
            DoubleArrayVector block = new DoubleArrayVector(values, positions, blockFactory);
            blockFactory.adjustBreaker(block.ramBytesUsed() - preAdjustedBytes);
            success = true;
            DoubleArrayVector doubleArrayVector = block;
            return doubleArrayVector;
        }
        finally {
            if (!success) {
                blockFactory.adjustBreaker(-preAdjustedBytes);
            }
        }
    }

    void writeArrayVector(int positions, StreamOutput out) throws IOException {
        for (int i = 0; i < positions; ++i) {
            out.writeDouble(this.values[i]);
        }
    }

    @Override
    public DoubleBlock asBlock() {
        return new DoubleVectorBlock(this);
    }

    @Override
    public double getDouble(int position) {
        return this.values[position];
    }

    @Override
    public ElementType elementType() {
        return ElementType.DOUBLE;
    }

    @Override
    public boolean isConstant() {
        return false;
    }

    @Override
    public DoubleVector filter(int ... positions) {
        try (DoubleVector.Builder builder = this.blockFactory().newDoubleVectorBuilder(positions.length);){
            for (int pos : positions) {
                builder.appendDouble(this.values[pos]);
            }
            DoubleVector doubleVector = builder.build();
            return doubleVector;
        }
    }

    public ReleasableIterator<DoubleBlock> lookup(IntBlock positions, ByteSizeValue targetBlockSize) {
        return new DoubleLookup(this.asBlock(), positions, targetBlockSize);
    }

    public static long ramBytesEstimated(double[] values) {
        return BASE_RAM_BYTES_USED + RamUsageEstimator.sizeOf((double[])values);
    }

    public long ramBytesUsed() {
        return DoubleArrayVector.ramBytesEstimated(this.values);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof DoubleVector) {
            DoubleVector that = (DoubleVector)obj;
            return DoubleVector.equals(this, that);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return DoubleVector.hash(this);
    }

    public String toString() {
        String valuesString = IntStream.range(0, this.getPositionCount()).limit(10L).mapToObj(n -> String.valueOf(this.values[n])).collect(Collectors.joining(", ", "[", this.getPositionCount() > 10 ? ", ...]" : "]"));
        return this.getClass().getSimpleName() + "[positions=" + this.getPositionCount() + ", values=" + valuesString + "]";
    }
}

