/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.data;

import java.io.IOException;
import java.util.Objects;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.RamUsageEstimator;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.compute.data.AbstractNonThreadSafeRefCounted;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BlockFactory;
import org.elasticsearch.compute.data.BlockStreamInput;
import org.elasticsearch.compute.data.BooleanBlock;
import org.elasticsearch.compute.data.BytesRefBlock;
import org.elasticsearch.compute.data.ConstantNullVector;
import org.elasticsearch.compute.data.DoubleBlock;
import org.elasticsearch.compute.data.ElementType;
import org.elasticsearch.compute.data.FloatBlock;
import org.elasticsearch.compute.data.IntBlock;
import org.elasticsearch.compute.data.LongBlock;
import org.elasticsearch.compute.data.OrdinalBytesRefBlock;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.ReleasableIterator;

final class ConstantNullBlock
extends AbstractNonThreadSafeRefCounted
implements BooleanBlock,
IntBlock,
LongBlock,
FloatBlock,
DoubleBlock,
BytesRefBlock {
    private static final long BASE_RAM_BYTES_USED = RamUsageEstimator.shallowSizeOfInstance(ConstantNullBlock.class);
    private final int positionCount;
    private BlockFactory blockFactory;
    public static final NamedWriteableRegistry.Entry ENTRY = new NamedWriteableRegistry.Entry(Block.class, "ConstantNullBlock", in -> ((BlockStreamInput)in).readConstantNullBlock());

    ConstantNullBlock(int positionCount, BlockFactory blockFactory) {
        this.positionCount = positionCount;
        this.blockFactory = blockFactory;
    }

    @Override
    public ConstantNullVector asVector() {
        return null;
    }

    @Override
    public OrdinalBytesRefBlock asOrdinals() {
        return null;
    }

    @Override
    public boolean isNull(int position) {
        return true;
    }

    @Override
    public boolean areAllValuesNull() {
        return true;
    }

    @Override
    public boolean mayHaveNulls() {
        return true;
    }

    @Override
    public boolean mayHaveMultivaluedFields() {
        return false;
    }

    @Override
    public boolean doesHaveMultivaluedFields() {
        return false;
    }

    @Override
    public ElementType elementType() {
        return ElementType.NULL;
    }

    @Override
    public ConstantNullBlock filter(int ... positions) {
        return (ConstantNullBlock)this.blockFactory().newConstantNullBlock(positions.length);
    }

    public ReleasableIterator<ConstantNullBlock> lookup(IntBlock positions, ByteSizeValue targetBlockSize) {
        return ReleasableIterator.single((Releasable)((ConstantNullBlock)positions.blockFactory().newConstantNullBlock(positions.getPositionCount())));
    }

    @Override
    public String getWriteableName() {
        return "ConstantNullBlock";
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeVInt(this.getPositionCount());
    }

    @Override
    public Block.MvOrdering mvOrdering() {
        return Block.MvOrdering.UNORDERED;
    }

    @Override
    public ConstantNullBlock expand() {
        this.incRef();
        return this;
    }

    public long ramBytesUsed() {
        return BASE_RAM_BYTES_USED;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof ConstantNullBlock) {
            ConstantNullBlock that = (ConstantNullBlock)obj;
            return this.getPositionCount() == that.getPositionCount();
        }
        return false;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.getPositionCount());
    }

    public String toString() {
        return "ConstantNullBlock[positions=" + this.getPositionCount() + "]";
    }

    @Override
    public void closeInternal() {
        this.blockFactory().adjustBreaker(-this.ramBytesUsed());
    }

    @Override
    public boolean getBoolean(int valueIndex) {
        assert (false) : "null block";
        throw new UnsupportedOperationException("null block");
    }

    @Override
    public BytesRef getBytesRef(int valueIndex, BytesRef dest) {
        assert (false) : "null block";
        throw new UnsupportedOperationException("null block");
    }

    @Override
    public float getFloat(int valueIndex) {
        assert (false) : "null block";
        throw new UnsupportedOperationException("null block");
    }

    @Override
    public double getDouble(int valueIndex) {
        assert (false) : "null block";
        throw new UnsupportedOperationException("null block");
    }

    @Override
    public int getInt(int valueIndex) {
        assert (false) : "null block";
        throw new UnsupportedOperationException("null block");
    }

    @Override
    public long getLong(int valueIndex) {
        assert (false) : "null block";
        throw new UnsupportedOperationException("null block");
    }

    @Override
    public int getTotalValueCount() {
        return 0;
    }

    @Override
    public int getPositionCount() {
        return this.positionCount;
    }

    @Override
    public int getFirstValueIndex(int position) {
        return 0;
    }

    @Override
    public int getValueCount(int position) {
        return 0;
    }

    @Override
    public BlockFactory blockFactory() {
        return this.blockFactory;
    }

    @Override
    public void allowPassingToDifferentDriver() {
        this.blockFactory = this.blockFactory.parent();
    }

    static class Builder
    implements Block.Builder {
        final BlockFactory blockFactory;
        private int positionCount;
        private boolean closed = false;

        Builder(BlockFactory blockFactory) {
            this.blockFactory = blockFactory;
        }

        @Override
        public Builder appendNull() {
            ++this.positionCount;
            return this;
        }

        @Override
        public Builder beginPositionEntry() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Builder endPositionEntry() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Builder copyFrom(Block block, int beginInclusive, int endExclusive) {
            for (int i = beginInclusive; i < endExclusive; ++i) {
                if (block.isNull(i)) continue;
                throw new UnsupportedOperationException("can't append non-null values to a null block");
            }
            this.positionCount += endExclusive - beginInclusive;
            return this;
        }

        @Override
        public Block.Builder mvOrdering(Block.MvOrdering mvOrdering) {
            return this;
        }

        @Override
        public long estimatedBytes() {
            return BASE_RAM_BYTES_USED;
        }

        @Override
        public Block build() {
            if (this.closed) {
                throw new IllegalStateException("already closed");
            }
            this.close();
            return this.blockFactory.newConstantNullBlock(this.positionCount);
        }

        public void close() {
            this.closed = true;
        }
    }
}

