/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.data;

import org.apache.lucene.util.RamUsageEstimator;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.compute.data.AbstractVector;
import org.elasticsearch.compute.data.BlockFactory;
import org.elasticsearch.compute.data.ElementType;
import org.elasticsearch.compute.data.IntBlock;
import org.elasticsearch.compute.data.IntLookup;
import org.elasticsearch.compute.data.IntVector;
import org.elasticsearch.compute.data.IntVectorBlock;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.ReleasableIterator;

final class ConstantIntVector
extends AbstractVector
implements IntVector {
    static final long RAM_BYTES_USED = RamUsageEstimator.shallowSizeOfInstance(ConstantIntVector.class);
    private final int value;

    ConstantIntVector(int value, int positionCount, BlockFactory blockFactory) {
        super(positionCount, blockFactory);
        this.value = value;
    }

    @Override
    public int getInt(int position) {
        return this.value;
    }

    @Override
    public IntBlock asBlock() {
        return new IntVectorBlock(this);
    }

    @Override
    public IntVector filter(int ... positions) {
        return this.blockFactory().newConstantIntVector(this.value, positions.length);
    }

    public ReleasableIterator<IntBlock> lookup(IntBlock positions, ByteSizeValue targetBlockSize) {
        if (positions.getPositionCount() == 0) {
            return ReleasableIterator.empty();
        }
        IntVector positionsVector = positions.asVector();
        if (positionsVector == null) {
            return new IntLookup(this.asBlock(), positions, targetBlockSize);
        }
        int min = positionsVector.min();
        if (min < 0) {
            throw new IllegalArgumentException("invalid position [" + min + "]");
        }
        if (min > this.getPositionCount()) {
            return ReleasableIterator.single((Releasable)((IntBlock)positions.blockFactory().newConstantNullBlock(positions.getPositionCount())));
        }
        if (positionsVector.max() < this.getPositionCount()) {
            return ReleasableIterator.single((Releasable)positions.blockFactory().newConstantIntBlockWith(this.value, positions.getPositionCount()));
        }
        return new IntLookup(this.asBlock(), positions, targetBlockSize);
    }

    @Override
    public int min() {
        return this.value;
    }

    @Override
    public int max() {
        return this.value;
    }

    @Override
    public ElementType elementType() {
        return ElementType.INT;
    }

    @Override
    public boolean isConstant() {
        return true;
    }

    public long ramBytesUsed() {
        return RAM_BYTES_USED;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof IntVector) {
            IntVector that = (IntVector)obj;
            return IntVector.equals(this, that);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return IntVector.hash(this);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[positions=" + this.getPositionCount() + ", value=" + this.value + "]";
    }
}

