/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.data;

import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.RamUsageEstimator;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.compute.data.AbstractVector;
import org.elasticsearch.compute.data.BlockFactory;
import org.elasticsearch.compute.data.BytesRefBlock;
import org.elasticsearch.compute.data.BytesRefLookup;
import org.elasticsearch.compute.data.BytesRefVector;
import org.elasticsearch.compute.data.BytesRefVectorBlock;
import org.elasticsearch.compute.data.ElementType;
import org.elasticsearch.compute.data.IntBlock;
import org.elasticsearch.compute.data.IntVector;
import org.elasticsearch.compute.data.OrdinalBytesRefVector;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.ReleasableIterator;

final class ConstantBytesRefVector
extends AbstractVector
implements BytesRefVector {
    static final long BASE_RAM_BYTES_USED = RamUsageEstimator.shallowSizeOfInstance(ConstantBytesRefVector.class) + RamUsageEstimator.shallowSizeOfInstance(BytesRef.class);
    private final BytesRef value;

    ConstantBytesRefVector(BytesRef value, int positionCount, BlockFactory blockFactory) {
        super(positionCount, blockFactory);
        this.value = value;
    }

    @Override
    public BytesRef getBytesRef(int position, BytesRef ignore) {
        return this.value;
    }

    @Override
    public BytesRefBlock asBlock() {
        return new BytesRefVectorBlock(this);
    }

    @Override
    public OrdinalBytesRefVector asOrdinals() {
        return null;
    }

    @Override
    public BytesRefVector filter(int ... positions) {
        return this.blockFactory().newConstantBytesRefVector(this.value, positions.length);
    }

    public ReleasableIterator<BytesRefBlock> lookup(IntBlock positions, ByteSizeValue targetBlockSize) {
        if (positions.getPositionCount() == 0) {
            return ReleasableIterator.empty();
        }
        IntVector positionsVector = positions.asVector();
        if (positionsVector == null) {
            return new BytesRefLookup(this.asBlock(), positions, targetBlockSize);
        }
        int min = positionsVector.min();
        if (min < 0) {
            throw new IllegalArgumentException("invalid position [" + min + "]");
        }
        if (min > this.getPositionCount()) {
            return ReleasableIterator.single((Releasable)((BytesRefBlock)positions.blockFactory().newConstantNullBlock(positions.getPositionCount())));
        }
        if (positionsVector.max() < this.getPositionCount()) {
            return ReleasableIterator.single((Releasable)positions.blockFactory().newConstantBytesRefBlockWith(this.value, positions.getPositionCount()));
        }
        return new BytesRefLookup(this.asBlock(), positions, targetBlockSize);
    }

    @Override
    public ElementType elementType() {
        return ElementType.BYTES_REF;
    }

    @Override
    public boolean isConstant() {
        return true;
    }

    public static long ramBytesUsed(BytesRef value) {
        return BASE_RAM_BYTES_USED + RamUsageEstimator.sizeOf((byte[])value.bytes);
    }

    public long ramBytesUsed() {
        return ConstantBytesRefVector.ramBytesUsed(this.value);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof BytesRefVector) {
            BytesRefVector that = (BytesRefVector)obj;
            return BytesRefVector.equals(this, that);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return BytesRefVector.hash(this);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[positions=" + this.getPositionCount() + ", value=" + this.value + "]";
    }
}

