/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.data;

import java.io.IOException;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.lucene.util.RamUsageEstimator;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.compute.data.AbstractVector;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BlockFactory;
import org.elasticsearch.compute.data.BooleanBlock;
import org.elasticsearch.compute.data.BooleanLookup;
import org.elasticsearch.compute.data.BooleanVector;
import org.elasticsearch.compute.data.BooleanVectorBlock;
import org.elasticsearch.compute.data.ElementType;
import org.elasticsearch.compute.data.IntBlock;
import org.elasticsearch.core.ReleasableIterator;

final class BooleanArrayVector
extends AbstractVector
implements BooleanVector {
    static final long BASE_RAM_BYTES_USED = RamUsageEstimator.shallowSizeOfInstance(BooleanArrayVector.class) + RamUsageEstimator.shallowSizeOfInstance(BooleanVectorBlock.class) + (long)Block.PAGE_MEM_OVERHEAD_PER_BLOCK;
    private final boolean[] values;

    BooleanArrayVector(boolean[] values, int positionCount, BlockFactory blockFactory) {
        super(positionCount, blockFactory);
        this.values = values;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static BooleanArrayVector readArrayVector(int positions, StreamInput in, BlockFactory blockFactory) throws IOException {
        long preAdjustedBytes = (long)RamUsageEstimator.NUM_BYTES_ARRAY_HEADER + (long)positions * 1L;
        blockFactory.adjustBreaker(preAdjustedBytes);
        boolean success = false;
        try {
            boolean[] values = new boolean[positions];
            for (int i = 0; i < positions; ++i) {
                values[i] = in.readBoolean();
            }
            BooleanArrayVector block = new BooleanArrayVector(values, positions, blockFactory);
            blockFactory.adjustBreaker(block.ramBytesUsed() - preAdjustedBytes);
            success = true;
            BooleanArrayVector booleanArrayVector = block;
            return booleanArrayVector;
        }
        finally {
            if (!success) {
                blockFactory.adjustBreaker(-preAdjustedBytes);
            }
        }
    }

    void writeArrayVector(int positions, StreamOutput out) throws IOException {
        for (int i = 0; i < positions; ++i) {
            out.writeBoolean(this.values[i]);
        }
    }

    @Override
    public BooleanBlock asBlock() {
        return new BooleanVectorBlock(this);
    }

    @Override
    public boolean getBoolean(int position) {
        return this.values[position];
    }

    @Override
    public ElementType elementType() {
        return ElementType.BOOLEAN;
    }

    @Override
    public boolean isConstant() {
        return false;
    }

    @Override
    public BooleanVector filter(int ... positions) {
        try (BooleanVector.Builder builder = this.blockFactory().newBooleanVectorBuilder(positions.length);){
            for (int pos : positions) {
                builder.appendBoolean(this.values[pos]);
            }
            BooleanVector booleanVector = builder.build();
            return booleanVector;
        }
    }

    public ReleasableIterator<BooleanBlock> lookup(IntBlock positions, ByteSizeValue targetBlockSize) {
        return new BooleanLookup(this.asBlock(), positions, targetBlockSize);
    }

    public static long ramBytesEstimated(boolean[] values) {
        return BASE_RAM_BYTES_USED + RamUsageEstimator.sizeOf((boolean[])values);
    }

    public long ramBytesUsed() {
        return BooleanArrayVector.ramBytesEstimated(this.values);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof BooleanVector) {
            BooleanVector that = (BooleanVector)obj;
            return BooleanVector.equals(this, that);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return BooleanVector.hash(this);
    }

    public String toString() {
        String valuesString = IntStream.range(0, this.getPositionCount()).limit(10L).mapToObj(n -> String.valueOf(this.values[n])).collect(Collectors.joining(", ", "[", this.getPositionCount() > 10 ? ", ...]" : "]"));
        return this.getClass().getSimpleName() + "[positions=" + this.getPositionCount() + ", values=" + valuesString + "]";
    }
}

