/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.aggregation.table;

import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.compute.aggregation.table.AscendingSequenceRowInTableLookup;
import org.elasticsearch.compute.aggregation.table.BlockHashRowInTableLookup;
import org.elasticsearch.compute.aggregation.table.EmptyRowInTableLookup;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BlockFactory;
import org.elasticsearch.compute.data.ElementType;
import org.elasticsearch.compute.data.IntBlock;
import org.elasticsearch.compute.data.IntVector;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.ReleasableIterator;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public abstract class RowInTableLookup
implements Releasable {
    public abstract ReleasableIterator<IntBlock> lookup(Page var1, ByteSizeValue var2);

    public abstract String toString();

    public static RowInTableLookup build(BlockFactory blockFactory, Block[] keys) {
        RowInTableLookup lookup;
        int positions = keys[0].getPositionCount();
        for (int k = 0; k < keys.length; ++k) {
            if (positions != keys[k].getPositionCount()) {
                throw new IllegalArgumentException("keys must have the same number of positions but [" + positions + "] != [" + keys[k].getPositionCount() + "]");
            }
            if (!keys[k].doesHaveMultivaluedFields()) continue;
            throw new IllegalArgumentException("only single valued keys are supported");
        }
        if (positions == 0) {
            return new EmptyRowInTableLookup(blockFactory);
        }
        if (keys.length == 1 && (lookup = RowInTableLookup.single(blockFactory, keys[0])) != null) {
            return lookup;
        }
        return new BlockHashRowInTableLookup(blockFactory, keys);
    }

    private static RowInTableLookup single(BlockFactory blockFactory, Block b) {
        if (b.elementType() != ElementType.INT) {
            return null;
        }
        IntVector v = (IntVector)b.asVector();
        if (v == null) {
            return null;
        }
        int first = v.getInt(0);
        for (int i = 1; i < v.getPositionCount(); ++i) {
            if (v.getInt(i) - first == i) continue;
            return null;
        }
        return new AscendingSequenceRowInTableLookup(blockFactory, first, first + v.getPositionCount());
    }
}

