/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.aggregation.blockhash;

import java.io.IOException;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.io.stream.BytesStreamOutput;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.common.util.BitArray;
import org.elasticsearch.common.util.BytesRefArray;
import org.elasticsearch.common.util.BytesRefHash;
import org.elasticsearch.compute.aggregation.GroupingAggregatorFunction;
import org.elasticsearch.compute.aggregation.SeenGroupIds;
import org.elasticsearch.compute.aggregation.blockhash.BlockHash;
import org.elasticsearch.compute.data.BlockFactory;
import org.elasticsearch.compute.data.BytesRefBlock;
import org.elasticsearch.compute.data.BytesRefVector;
import org.elasticsearch.compute.data.IntBlock;
import org.elasticsearch.compute.data.IntVector;
import org.elasticsearch.compute.data.OrdinalBytesRefBlock;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.compute.operator.mvdedupe.MultivalueDedupe;
import org.elasticsearch.compute.operator.mvdedupe.MultivalueDedupeBytesRef;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.ReleasableIterator;

final class BytesRefBlockHash
extends BlockHash {
    private final int channel;
    final BytesRefHash hash;
    private boolean seenNull;

    BytesRefBlockHash(int channel, BlockFactory blockFactory) {
        super(blockFactory);
        this.channel = channel;
        this.hash = new BytesRefHash(1L, blockFactory.bigArrays());
    }

    @Override
    public void add(Page page, GroupingAggregatorFunction.AddInput addInput) {
        Object block = page.getBlock(this.channel);
        if (block.areAllValuesNull()) {
            this.seenNull = true;
            try (IntVector groupIds = this.blockFactory.newConstantIntVector(0, block.getPositionCount());){
                addInput.add(0, groupIds);
            }
            return;
        }
        BytesRefBlock castBlock = (BytesRefBlock)block;
        BytesRefVector vector = castBlock.asVector();
        if (vector == null) {
            try (IntBlock groupIds = this.add(castBlock);){
                addInput.add(0, groupIds);
            }
            return;
        }
        try (IntVector groupIds = this.add(vector);){
            addInput.add(0, groupIds);
        }
    }

    IntVector add(BytesRefVector vector) {
        BytesRef scratch = new BytesRef();
        int positions = vector.getPositionCount();
        try (IntVector.FixedBuilder builder = this.blockFactory.newIntVectorFixedBuilder(positions);){
            for (int i = 0; i < positions; ++i) {
                BytesRef v = vector.getBytesRef(i, scratch);
                builder.appendInt(Math.toIntExact(BytesRefBlockHash.hashOrdToGroupNullReserved(this.hash.add(v))));
            }
            IntVector intVector = builder.build();
            return intVector;
        }
    }

    IntBlock add(BytesRefBlock block) {
        OrdinalBytesRefBlock ordinals = block.asOrdinals();
        if (ordinals != null) {
            return this.addOrdinalsBlock(ordinals);
        }
        MultivalueDedupe.HashResult result = new MultivalueDedupeBytesRef(block).hashAdd(this.blockFactory, this.hash);
        this.seenNull |= result.sawNull();
        return result.ords();
    }

    @Override
    public ReleasableIterator<IntBlock> lookup(Page page, ByteSizeValue targetBlockSize) {
        Object block = page.getBlock(this.channel);
        if (block.areAllValuesNull()) {
            return ReleasableIterator.single((Releasable)this.blockFactory.newConstantIntVector(0, block.getPositionCount()).asBlock());
        }
        BytesRefBlock castBlock = (BytesRefBlock)block;
        BytesRefVector vector = castBlock.asVector();
        if (vector == null) {
            return ReleasableIterator.single((Releasable)this.lookup(castBlock));
        }
        return ReleasableIterator.single((Releasable)this.lookup(vector));
    }

    private IntBlock addOrdinalsBlock(OrdinalBytesRefBlock inputBlock) {
        IntBlock inputOrds = inputBlock.getOrdinalsBlock();
        try (IntBlock.Builder builder = this.blockFactory.newIntBlockBuilder(inputOrds.getPositionCount());){
            IntBlock intBlock;
            block18: {
                IntVector hashOrds = this.add(inputBlock.getDictionaryVector());
                try {
                    block14: for (int i = 0; i < inputOrds.getPositionCount(); ++i) {
                        int valueCount = inputOrds.getValueCount(i);
                        int firstIndex = inputOrds.getFirstValueIndex(i);
                        switch (valueCount) {
                            case 0: {
                                builder.appendInt(0);
                                this.seenNull = true;
                                continue block14;
                            }
                            case 1: {
                                int ord = hashOrds.getInt(inputOrds.getInt(firstIndex));
                                builder.appendInt(ord);
                                continue block14;
                            }
                            default: {
                                builder.beginPositionEntry();
                                for (int v = 0; v < valueCount; ++v) {
                                    int ord = hashOrds.getInt(inputOrds.getInt(firstIndex + i));
                                    builder.appendInt(ord);
                                }
                                builder.endPositionEntry();
                            }
                        }
                    }
                    intBlock = builder.build();
                    if (hashOrds == null) break block18;
                }
                catch (Throwable throwable) {
                    if (hashOrds != null) {
                        try {
                            hashOrds.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                hashOrds.close();
            }
            return intBlock;
        }
    }

    private IntBlock lookup(BytesRefVector vector) {
        BytesRef scratch = new BytesRef();
        int positions = vector.getPositionCount();
        try (IntBlock.Builder builder = this.blockFactory.newIntBlockBuilder(positions);){
            for (int i = 0; i < positions; ++i) {
                BytesRef v = vector.getBytesRef(i, scratch);
                long found = this.hash.find(v);
                if (found < 0L) {
                    builder.appendNull();
                    continue;
                }
                builder.appendInt(Math.toIntExact(BytesRefBlockHash.hashOrdToGroupNullReserved(found)));
            }
            IntBlock intBlock = builder.build();
            return intBlock;
        }
    }

    private IntBlock lookup(BytesRefBlock block) {
        return new MultivalueDedupeBytesRef(block).hashLookup(this.blockFactory, this.hash);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public BytesRefBlock[] getKeys() {
        if (this.seenNull) {
            try (BytesRefBlock.Builder builder = this.blockFactory.newBytesRefBlockBuilder(Math.toIntExact(this.hash.size() + 1L));){
                builder.appendNull();
                BytesRef spare = new BytesRef();
                for (long i = 0L; i < this.hash.size(); ++i) {
                    builder.appendBytesRef(this.hash.get(i, spare));
                }
                BytesRefBlock[] i = new BytesRefBlock[]{builder.build()};
                return i;
            }
        }
        int size = Math.toIntExact(this.hash.size());
        try (BytesStreamOutput out = new BytesStreamOutput();){
            BytesRefBlock[] bytesRefBlockArray;
            block21: {
                this.hash.getBytesRefs().writeTo((StreamOutput)out);
                StreamInput in = out.bytes().streamInput();
                try {
                    bytesRefBlockArray = new BytesRefBlock[]{this.blockFactory.newBytesRefArrayVector(new BytesRefArray(in, BigArrays.NON_RECYCLING_INSTANCE), size).asBlock()};
                    if (in == null) break block21;
                }
                catch (Throwable throwable) {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                in.close();
            }
            return bytesRefBlockArray;
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public IntVector nonEmpty() {
        return IntVector.range(this.seenNull ? 0 : 1, Math.toIntExact(this.hash.size() + 1L), this.blockFactory);
    }

    @Override
    public BitArray seenGroupIds(BigArrays bigArrays) {
        return new SeenGroupIds.Range(this.seenNull ? 0 : 1, Math.toIntExact(this.hash.size() + 1L)).seenGroupIds(bigArrays);
    }

    public void close() {
        this.hash.close();
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("BytesRefBlockHash{channel=").append(this.channel);
        b.append(", entries=").append(this.hash.size());
        b.append(", size=").append(ByteSizeValue.ofBytes((long)this.hash.ramBytesUsed()));
        b.append(", seenNull=").append(this.seenNull);
        return b.append('}').toString();
    }
}

