/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.aggregation.blockhash;

import org.elasticsearch.compute.aggregation.GroupingAggregatorFunction;
import org.elasticsearch.compute.data.BlockFactory;
import org.elasticsearch.compute.data.IntBlock;
import org.elasticsearch.core.Releasable;

public class AbstractAddBlock
implements Releasable {
    private final BlockFactory blockFactory;
    private final int emitBatchSize;
    private final GroupingAggregatorFunction.AddInput addInput;
    private int positionOffset = 0;
    private int added = 0;
    protected IntBlock.Builder ords;

    public AbstractAddBlock(BlockFactory blockFactory, int emitBatchSize, GroupingAggregatorFunction.AddInput addInput) {
        this.blockFactory = blockFactory;
        this.emitBatchSize = emitBatchSize;
        this.addInput = addInput;
        this.ords = blockFactory.newIntBlockBuilder(emitBatchSize);
    }

    protected final void addedValue(int position) {
        if (++this.added % this.emitBatchSize == 0) {
            this.rollover(position + 1);
        }
    }

    protected final void addedValueInMultivaluePosition(int position) {
        if (++this.added % this.emitBatchSize == 0) {
            this.ords.endPositionEntry();
            this.rollover(position);
            this.ords.beginPositionEntry();
        }
    }

    protected final void emitOrds() {
        try (IntBlock ordsBlock = this.ords.build();){
            this.addInput.add(this.positionOffset, ordsBlock);
        }
    }

    private void rollover(int position) {
        this.emitOrds();
        this.positionOffset = position;
        this.ords = this.blockFactory.newIntBlockBuilder(this.emitBatchSize);
    }

    public void close() {
        this.ords.close();
    }
}

