/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.aggregation;

import java.util.List;
import org.elasticsearch.compute.aggregation.GroupingAggregatorFunction;
import org.elasticsearch.compute.aggregation.IntermediateStateDesc;
import org.elasticsearch.compute.aggregation.SeenGroupIds;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.CompositeBlock;
import org.elasticsearch.compute.data.ElementType;
import org.elasticsearch.compute.data.IntVector;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.compute.operator.DriverContext;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;

public class ToPartialGroupingAggregatorFunction
implements GroupingAggregatorFunction {
    private static final List<IntermediateStateDesc> INTERMEDIATE_STATE_DESC = List.of(new IntermediateStateDesc("partial", ElementType.COMPOSITE, "partial_agg"));
    private final GroupingAggregatorFunction delegate;
    private final List<Integer> channels;

    public static List<IntermediateStateDesc> intermediateStateDesc() {
        return INTERMEDIATE_STATE_DESC;
    }

    public ToPartialGroupingAggregatorFunction(GroupingAggregatorFunction delegate, List<Integer> channels) {
        this.delegate = delegate;
        this.channels = channels;
    }

    @Override
    public GroupingAggregatorFunction.AddInput prepareProcessPage(SeenGroupIds seenGroupIds, Page page) {
        return this.delegate.prepareProcessPage(seenGroupIds, page);
    }

    @Override
    public void addIntermediateInput(int positionOffset, IntVector groupIdVector, Page page) {
        CompositeBlock inputBlock = (CompositeBlock)page.getBlock(this.channels.get(0));
        this.delegate.addIntermediateInput(positionOffset, groupIdVector, inputBlock.asPage());
    }

    @Override
    public void addIntermediateRowInput(int groupId, GroupingAggregatorFunction input, int position) {
        if (input instanceof ToPartialGroupingAggregatorFunction) {
            ToPartialGroupingAggregatorFunction toPartial = (ToPartialGroupingAggregatorFunction)input;
            input = toPartial.delegate;
        }
        this.delegate.addIntermediateRowInput(groupId, input, position);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void evaluateIntermediate(Block[] blocks, int offset, IntVector selected) {
        Releasable[] partialBlocks = new Block[this.delegate.intermediateBlockCount()];
        boolean success = false;
        try {
            this.delegate.evaluateIntermediate((Block[])partialBlocks, 0, selected);
            blocks[offset] = new CompositeBlock((Block[])partialBlocks);
            success = true;
        }
        finally {
            if (!success) {
                Releasables.close((Releasable[])partialBlocks);
            }
        }
    }

    @Override
    public void evaluateFinal(Block[] blocks, int offset, IntVector selected, DriverContext driverContext) {
        this.evaluateIntermediate(blocks, offset, selected);
    }

    @Override
    public int intermediateBlockCount() {
        return INTERMEDIATE_STATE_DESC.size();
    }

    public void close() {
        Releasables.close((Releasable)this.delegate);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[channels=" + this.channels + ",delegate=" + this.delegate + "]";
    }
}

