/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.aggregation;

import java.util.List;
import org.elasticsearch.compute.aggregation.AggregatorFunction;
import org.elasticsearch.compute.aggregation.IntermediateStateDesc;
import org.elasticsearch.compute.aggregation.SumDoubleAggregator;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BooleanBlock;
import org.elasticsearch.compute.data.BooleanVector;
import org.elasticsearch.compute.data.DoubleBlock;
import org.elasticsearch.compute.data.DoubleVector;
import org.elasticsearch.compute.data.ElementType;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.compute.operator.DriverContext;

public final class SumDoubleAggregatorFunction
implements AggregatorFunction {
    private static final List<IntermediateStateDesc> INTERMEDIATE_STATE_DESC = List.of(new IntermediateStateDesc("value", ElementType.DOUBLE), new IntermediateStateDesc("delta", ElementType.DOUBLE), new IntermediateStateDesc("seen", ElementType.BOOLEAN));
    private final DriverContext driverContext;
    private final SumDoubleAggregator.SumState state;
    private final List<Integer> channels;

    public SumDoubleAggregatorFunction(DriverContext driverContext, List<Integer> channels, SumDoubleAggregator.SumState state) {
        this.driverContext = driverContext;
        this.channels = channels;
        this.state = state;
    }

    public static SumDoubleAggregatorFunction create(DriverContext driverContext, List<Integer> channels) {
        return new SumDoubleAggregatorFunction(driverContext, channels, SumDoubleAggregator.initSingle());
    }

    public static List<IntermediateStateDesc> intermediateStateDesc() {
        return INTERMEDIATE_STATE_DESC;
    }

    @Override
    public int intermediateBlockCount() {
        return INTERMEDIATE_STATE_DESC.size();
    }

    @Override
    public void addRawInput(Page page) {
        DoubleBlock block = (DoubleBlock)page.getBlock(this.channels.get(0));
        DoubleVector vector = block.asVector();
        if (vector != null) {
            this.addRawVector(vector);
        } else {
            this.addRawBlock(block);
        }
    }

    private void addRawVector(DoubleVector vector) {
        this.state.seen(true);
        for (int i = 0; i < vector.getPositionCount(); ++i) {
            SumDoubleAggregator.combine(this.state, vector.getDouble(i));
        }
    }

    private void addRawBlock(DoubleBlock block) {
        for (int p = 0; p < block.getPositionCount(); ++p) {
            if (block.isNull(p)) continue;
            this.state.seen(true);
            int start = block.getFirstValueIndex(p);
            int end = start + block.getValueCount(p);
            for (int i = start; i < end; ++i) {
                SumDoubleAggregator.combine(this.state, block.getDouble(i));
            }
        }
    }

    @Override
    public void addIntermediateInput(Page page) {
        assert (this.channels.size() == this.intermediateBlockCount());
        assert (page.getBlockCount() >= this.channels.get(0) + SumDoubleAggregatorFunction.intermediateStateDesc().size());
        Object valueUncast = page.getBlock(this.channels.get(0));
        if (valueUncast.areAllValuesNull()) {
            return;
        }
        DoubleVector value = ((DoubleBlock)valueUncast).asVector();
        assert (value.getPositionCount() == 1);
        Object deltaUncast = page.getBlock(this.channels.get(1));
        if (deltaUncast.areAllValuesNull()) {
            return;
        }
        DoubleVector delta = ((DoubleBlock)deltaUncast).asVector();
        assert (delta.getPositionCount() == 1);
        Object seenUncast = page.getBlock(this.channels.get(2));
        if (seenUncast.areAllValuesNull()) {
            return;
        }
        BooleanVector seen = ((BooleanBlock)seenUncast).asVector();
        assert (seen.getPositionCount() == 1);
        SumDoubleAggregator.combineIntermediate(this.state, value.getDouble(0), delta.getDouble(0), seen.getBoolean(0));
    }

    @Override
    public void evaluateIntermediate(Block[] blocks, int offset, DriverContext driverContext) {
        this.state.toIntermediate(blocks, offset, driverContext);
    }

    @Override
    public void evaluateFinal(Block[] blocks, int offset, DriverContext driverContext) {
        if (!this.state.seen()) {
            blocks[offset] = driverContext.blockFactory().newConstantNullBlock(1);
            return;
        }
        blocks[offset] = SumDoubleAggregator.evaluateFinal(this.state, driverContext);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName()).append("[");
        sb.append("channels=").append(this.channels);
        sb.append("]");
        return sb.toString();
    }

    public void close() {
        this.state.close();
    }
}

