/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.aggregation;

import java.util.List;
import org.elasticsearch.compute.aggregation.GroupingAggregatorFunction;
import org.elasticsearch.compute.aggregation.IntermediateStateDesc;
import org.elasticsearch.compute.aggregation.RateIntAggregator;
import org.elasticsearch.compute.aggregation.SeenGroupIds;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.DoubleBlock;
import org.elasticsearch.compute.data.DoubleVector;
import org.elasticsearch.compute.data.ElementType;
import org.elasticsearch.compute.data.IntBlock;
import org.elasticsearch.compute.data.IntVector;
import org.elasticsearch.compute.data.LongBlock;
import org.elasticsearch.compute.data.LongVector;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.compute.operator.DriverContext;

public final class RateIntGroupingAggregatorFunction
implements GroupingAggregatorFunction {
    private static final List<IntermediateStateDesc> INTERMEDIATE_STATE_DESC = List.of(new IntermediateStateDesc("timestamps", ElementType.LONG), new IntermediateStateDesc("values", ElementType.INT), new IntermediateStateDesc("resets", ElementType.DOUBLE));
    private final RateIntAggregator.IntRateGroupingState state;
    private final List<Integer> channels;
    private final DriverContext driverContext;
    private final long unitInMillis;

    public RateIntGroupingAggregatorFunction(List<Integer> channels, RateIntAggregator.IntRateGroupingState state, DriverContext driverContext, long unitInMillis) {
        this.channels = channels;
        this.state = state;
        this.driverContext = driverContext;
        this.unitInMillis = unitInMillis;
    }

    public static RateIntGroupingAggregatorFunction create(List<Integer> channels, DriverContext driverContext, long unitInMillis) {
        return new RateIntGroupingAggregatorFunction(channels, RateIntAggregator.initGrouping(driverContext, unitInMillis), driverContext, unitInMillis);
    }

    public static List<IntermediateStateDesc> intermediateStateDesc() {
        return INTERMEDIATE_STATE_DESC;
    }

    @Override
    public int intermediateBlockCount() {
        return INTERMEDIATE_STATE_DESC.size();
    }

    @Override
    public GroupingAggregatorFunction.AddInput prepareProcessPage(SeenGroupIds seenGroupIds, Page page) {
        final IntBlock valuesBlock = (IntBlock)page.getBlock(this.channels.get(0));
        final IntVector valuesVector = valuesBlock.asVector();
        LongBlock timestampsBlock = (LongBlock)page.getBlock(this.channels.get(1));
        final LongVector timestampsVector = timestampsBlock.asVector();
        if (timestampsVector == null) {
            throw new IllegalStateException("expected @timestamp vector; but got a block");
        }
        if (valuesVector == null) {
            if (valuesBlock.mayHaveNulls()) {
                this.state.enableGroupIdTracking(seenGroupIds);
            }
            return new GroupingAggregatorFunction.AddInput(){

                @Override
                public void add(int positionOffset, IntBlock groupIds) {
                    RateIntGroupingAggregatorFunction.this.addRawInput(positionOffset, groupIds, valuesBlock, timestampsVector);
                }

                @Override
                public void add(int positionOffset, IntVector groupIds) {
                    RateIntGroupingAggregatorFunction.this.addRawInput(positionOffset, groupIds, valuesBlock, timestampsVector);
                }
            };
        }
        return new GroupingAggregatorFunction.AddInput(){

            @Override
            public void add(int positionOffset, IntBlock groupIds) {
                RateIntGroupingAggregatorFunction.this.addRawInput(positionOffset, groupIds, valuesVector, timestampsVector);
            }

            @Override
            public void add(int positionOffset, IntVector groupIds) {
                RateIntGroupingAggregatorFunction.this.addRawInput(positionOffset, groupIds, valuesVector, timestampsVector);
            }
        };
    }

    private void addRawInput(int positionOffset, IntVector groups, IntBlock values, LongVector timestamps) {
        for (int groupPosition = 0; groupPosition < groups.getPositionCount(); ++groupPosition) {
            int groupId = Math.toIntExact(groups.getInt(groupPosition));
            if (values.isNull(groupPosition + positionOffset)) continue;
            int valuesStart = values.getFirstValueIndex(groupPosition + positionOffset);
            int valuesEnd = valuesStart + values.getValueCount(groupPosition + positionOffset);
            for (int v = valuesStart; v < valuesEnd; ++v) {
                RateIntAggregator.combine(this.state, groupId, timestamps.getLong(v), values.getInt(v));
            }
        }
    }

    private void addRawInput(int positionOffset, IntVector groups, IntVector values, LongVector timestamps) {
        for (int groupPosition = 0; groupPosition < groups.getPositionCount(); ++groupPosition) {
            int groupId = Math.toIntExact(groups.getInt(groupPosition));
            int valuePosition = groupPosition + positionOffset;
            RateIntAggregator.combine(this.state, groupId, timestamps.getLong(valuePosition), values.getInt(valuePosition));
        }
    }

    private void addRawInput(int positionOffset, IntBlock groups, IntBlock values, LongVector timestamps) {
        for (int groupPosition = 0; groupPosition < groups.getPositionCount(); ++groupPosition) {
            if (groups.isNull(groupPosition)) continue;
            int groupStart = groups.getFirstValueIndex(groupPosition);
            int groupEnd = groupStart + groups.getValueCount(groupPosition);
            for (int g = groupStart; g < groupEnd; ++g) {
                int groupId = Math.toIntExact(groups.getInt(g));
                if (values.isNull(groupPosition + positionOffset)) continue;
                int valuesStart = values.getFirstValueIndex(groupPosition + positionOffset);
                int valuesEnd = valuesStart + values.getValueCount(groupPosition + positionOffset);
                for (int v = valuesStart; v < valuesEnd; ++v) {
                    RateIntAggregator.combine(this.state, groupId, timestamps.getLong(v), values.getInt(v));
                }
            }
        }
    }

    private void addRawInput(int positionOffset, IntBlock groups, IntVector values, LongVector timestamps) {
        for (int groupPosition = 0; groupPosition < groups.getPositionCount(); ++groupPosition) {
            if (groups.isNull(groupPosition)) continue;
            int groupStart = groups.getFirstValueIndex(groupPosition);
            int groupEnd = groupStart + groups.getValueCount(groupPosition);
            for (int g = groupStart; g < groupEnd; ++g) {
                int groupId = Math.toIntExact(groups.getInt(g));
                int valuePosition = groupPosition + positionOffset;
                RateIntAggregator.combine(this.state, groupId, timestamps.getLong(valuePosition), values.getInt(valuePosition));
            }
        }
    }

    @Override
    public void addIntermediateInput(int positionOffset, IntVector groups, Page page) {
        this.state.enableGroupIdTracking(new SeenGroupIds.Empty());
        assert (this.channels.size() == this.intermediateBlockCount());
        Object timestampsUncast = page.getBlock(this.channels.get(0));
        if (timestampsUncast.areAllValuesNull()) {
            return;
        }
        LongBlock timestamps = (LongBlock)timestampsUncast;
        Object valuesUncast = page.getBlock(this.channels.get(1));
        if (valuesUncast.areAllValuesNull()) {
            return;
        }
        IntBlock values = (IntBlock)valuesUncast;
        Object resetsUncast = page.getBlock(this.channels.get(2));
        if (resetsUncast.areAllValuesNull()) {
            return;
        }
        DoubleVector resets = ((DoubleBlock)resetsUncast).asVector();
        assert (timestamps.getPositionCount() == values.getPositionCount() && timestamps.getPositionCount() == resets.getPositionCount());
        for (int groupPosition = 0; groupPosition < groups.getPositionCount(); ++groupPosition) {
            int groupId = Math.toIntExact(groups.getInt(groupPosition));
            RateIntAggregator.combineIntermediate(this.state, groupId, timestamps, values, resets.getDouble(groupPosition + positionOffset), groupPosition + positionOffset);
        }
    }

    @Override
    public void addIntermediateRowInput(int groupId, GroupingAggregatorFunction input, int position) {
        if (input.getClass() != this.getClass()) {
            throw new IllegalArgumentException("expected " + this.getClass() + "; got " + input.getClass());
        }
        RateIntAggregator.IntRateGroupingState inState = ((RateIntGroupingAggregatorFunction)input).state;
        this.state.enableGroupIdTracking(new SeenGroupIds.Empty());
        RateIntAggregator.combineStates(this.state, groupId, inState, position);
    }

    @Override
    public void evaluateIntermediate(Block[] blocks, int offset, IntVector selected) {
        this.state.toIntermediate(blocks, offset, selected, this.driverContext);
    }

    @Override
    public void evaluateFinal(Block[] blocks, int offset, IntVector selected, DriverContext driverContext) {
        blocks[offset] = RateIntAggregator.evaluateFinal(this.state, selected, driverContext);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName()).append("[");
        sb.append("channels=").append(this.channels);
        sb.append("]");
        return sb.toString();
    }

    public void close() {
        this.state.close();
    }
}

