/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.aggregation;

import java.util.List;
import org.elasticsearch.compute.aggregation.AggregatorFunctionSupplier;
import org.elasticsearch.compute.aggregation.PercentileLongAggregatorFunction;
import org.elasticsearch.compute.aggregation.PercentileLongGroupingAggregatorFunction;
import org.elasticsearch.compute.operator.DriverContext;

public final class PercentileLongAggregatorFunctionSupplier
implements AggregatorFunctionSupplier {
    private final List<Integer> channels;
    private final double percentile;

    public PercentileLongAggregatorFunctionSupplier(List<Integer> channels, double percentile) {
        this.channels = channels;
        this.percentile = percentile;
    }

    @Override
    public PercentileLongAggregatorFunction aggregator(DriverContext driverContext) {
        return PercentileLongAggregatorFunction.create(driverContext, this.channels, this.percentile);
    }

    @Override
    public PercentileLongGroupingAggregatorFunction groupingAggregator(DriverContext driverContext) {
        return PercentileLongGroupingAggregatorFunction.create(this.channels, driverContext, this.percentile);
    }

    @Override
    public String describe() {
        return "percentile of longs";
    }
}

