/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.aggregation;

import java.util.List;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.compute.aggregation.AggregatorFunction;
import org.elasticsearch.compute.aggregation.IntermediateStateDesc;
import org.elasticsearch.compute.aggregation.PercentileFloatAggregator;
import org.elasticsearch.compute.aggregation.QuantileStates;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BytesRefBlock;
import org.elasticsearch.compute.data.BytesRefVector;
import org.elasticsearch.compute.data.ElementType;
import org.elasticsearch.compute.data.FloatBlock;
import org.elasticsearch.compute.data.FloatVector;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.compute.operator.DriverContext;

public final class PercentileFloatAggregatorFunction
implements AggregatorFunction {
    private static final List<IntermediateStateDesc> INTERMEDIATE_STATE_DESC = List.of(new IntermediateStateDesc("quart", ElementType.BYTES_REF));
    private final DriverContext driverContext;
    private final QuantileStates.SingleState state;
    private final List<Integer> channels;
    private final double percentile;

    public PercentileFloatAggregatorFunction(DriverContext driverContext, List<Integer> channels, QuantileStates.SingleState state, double percentile) {
        this.driverContext = driverContext;
        this.channels = channels;
        this.state = state;
        this.percentile = percentile;
    }

    public static PercentileFloatAggregatorFunction create(DriverContext driverContext, List<Integer> channels, double percentile) {
        return new PercentileFloatAggregatorFunction(driverContext, channels, PercentileFloatAggregator.initSingle(percentile), percentile);
    }

    public static List<IntermediateStateDesc> intermediateStateDesc() {
        return INTERMEDIATE_STATE_DESC;
    }

    @Override
    public int intermediateBlockCount() {
        return INTERMEDIATE_STATE_DESC.size();
    }

    @Override
    public void addRawInput(Page page) {
        FloatBlock block = (FloatBlock)page.getBlock(this.channels.get(0));
        FloatVector vector = block.asVector();
        if (vector != null) {
            this.addRawVector(vector);
        } else {
            this.addRawBlock(block);
        }
    }

    private void addRawVector(FloatVector vector) {
        for (int i = 0; i < vector.getPositionCount(); ++i) {
            PercentileFloatAggregator.combine(this.state, vector.getFloat(i));
        }
    }

    private void addRawBlock(FloatBlock block) {
        for (int p = 0; p < block.getPositionCount(); ++p) {
            if (block.isNull(p)) continue;
            int start = block.getFirstValueIndex(p);
            int end = start + block.getValueCount(p);
            for (int i = start; i < end; ++i) {
                PercentileFloatAggregator.combine(this.state, block.getFloat(i));
            }
        }
    }

    @Override
    public void addIntermediateInput(Page page) {
        assert (this.channels.size() == this.intermediateBlockCount());
        assert (page.getBlockCount() >= this.channels.get(0) + PercentileFloatAggregatorFunction.intermediateStateDesc().size());
        Object quartUncast = page.getBlock(this.channels.get(0));
        if (quartUncast.areAllValuesNull()) {
            return;
        }
        BytesRefVector quart = ((BytesRefBlock)quartUncast).asVector();
        assert (quart.getPositionCount() == 1);
        BytesRef scratch = new BytesRef();
        PercentileFloatAggregator.combineIntermediate(this.state, quart.getBytesRef(0, scratch));
    }

    @Override
    public void evaluateIntermediate(Block[] blocks, int offset, DriverContext driverContext) {
        this.state.toIntermediate(blocks, offset, driverContext);
    }

    @Override
    public void evaluateFinal(Block[] blocks, int offset, DriverContext driverContext) {
        blocks[offset] = PercentileFloatAggregator.evaluateFinal(this.state, driverContext);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName()).append("[");
        sb.append("channels=").append(this.channels);
        sb.append("]");
        return sb.toString();
    }

    public void close() {
        this.state.close();
    }
}

