/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.aggregation;

import java.util.List;
import org.elasticsearch.compute.aggregation.AggregatorFunction;
import org.elasticsearch.compute.aggregation.IntState;
import org.elasticsearch.compute.aggregation.IntermediateStateDesc;
import org.elasticsearch.compute.aggregation.MaxIntAggregator;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BooleanBlock;
import org.elasticsearch.compute.data.BooleanVector;
import org.elasticsearch.compute.data.ElementType;
import org.elasticsearch.compute.data.IntBlock;
import org.elasticsearch.compute.data.IntVector;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.compute.operator.DriverContext;

public final class MaxIntAggregatorFunction
implements AggregatorFunction {
    private static final List<IntermediateStateDesc> INTERMEDIATE_STATE_DESC = List.of(new IntermediateStateDesc("max", ElementType.INT), new IntermediateStateDesc("seen", ElementType.BOOLEAN));
    private final DriverContext driverContext;
    private final IntState state;
    private final List<Integer> channels;

    public MaxIntAggregatorFunction(DriverContext driverContext, List<Integer> channels, IntState state) {
        this.driverContext = driverContext;
        this.channels = channels;
        this.state = state;
    }

    public static MaxIntAggregatorFunction create(DriverContext driverContext, List<Integer> channels) {
        return new MaxIntAggregatorFunction(driverContext, channels, new IntState(MaxIntAggregator.init()));
    }

    public static List<IntermediateStateDesc> intermediateStateDesc() {
        return INTERMEDIATE_STATE_DESC;
    }

    @Override
    public int intermediateBlockCount() {
        return INTERMEDIATE_STATE_DESC.size();
    }

    @Override
    public void addRawInput(Page page) {
        IntBlock block = (IntBlock)page.getBlock(this.channels.get(0));
        IntVector vector = block.asVector();
        if (vector != null) {
            this.addRawVector(vector);
        } else {
            this.addRawBlock(block);
        }
    }

    private void addRawVector(IntVector vector) {
        this.state.seen(true);
        for (int i = 0; i < vector.getPositionCount(); ++i) {
            this.state.intValue(MaxIntAggregator.combine(this.state.intValue(), vector.getInt(i)));
        }
    }

    private void addRawBlock(IntBlock block) {
        for (int p = 0; p < block.getPositionCount(); ++p) {
            if (block.isNull(p)) continue;
            this.state.seen(true);
            int start = block.getFirstValueIndex(p);
            int end = start + block.getValueCount(p);
            for (int i = start; i < end; ++i) {
                this.state.intValue(MaxIntAggregator.combine(this.state.intValue(), block.getInt(i)));
            }
        }
    }

    @Override
    public void addIntermediateInput(Page page) {
        assert (this.channels.size() == this.intermediateBlockCount());
        assert (page.getBlockCount() >= this.channels.get(0) + MaxIntAggregatorFunction.intermediateStateDesc().size());
        Object maxUncast = page.getBlock(this.channels.get(0));
        if (maxUncast.areAllValuesNull()) {
            return;
        }
        IntVector max = ((IntBlock)maxUncast).asVector();
        assert (max.getPositionCount() == 1);
        Object seenUncast = page.getBlock(this.channels.get(1));
        if (seenUncast.areAllValuesNull()) {
            return;
        }
        BooleanVector seen = ((BooleanBlock)seenUncast).asVector();
        assert (seen.getPositionCount() == 1);
        if (seen.getBoolean(0)) {
            this.state.intValue(MaxIntAggregator.combine(this.state.intValue(), max.getInt(0)));
            this.state.seen(true);
        }
    }

    @Override
    public void evaluateIntermediate(Block[] blocks, int offset, DriverContext driverContext) {
        this.state.toIntermediate(blocks, offset, driverContext);
    }

    @Override
    public void evaluateFinal(Block[] blocks, int offset, DriverContext driverContext) {
        if (!this.state.seen()) {
            blocks[offset] = driverContext.blockFactory().newConstantNullBlock(1);
            return;
        }
        blocks[offset] = driverContext.blockFactory().newConstantIntBlockWith(this.state.intValue(), 1);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName()).append("[");
        sb.append("channels=").append(this.channels);
        sb.append("]");
        return sb.toString();
    }

    public void close() {
        this.state.close();
    }
}

