/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.aggregation;

import java.util.List;
import org.elasticsearch.compute.aggregation.AggregatorFunction;
import org.elasticsearch.compute.aggregation.GroupingAggregatorFunction;
import org.elasticsearch.compute.aggregation.IntermediateStateDesc;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.CompositeBlock;
import org.elasticsearch.compute.data.ElementType;
import org.elasticsearch.compute.data.IntVector;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.compute.operator.DriverContext;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;

public class FromPartialAggregatorFunction
implements AggregatorFunction {
    private static final List<IntermediateStateDesc> INTERMEDIATE_STATE_DESC = List.of(new IntermediateStateDesc("partial", ElementType.COMPOSITE, "partial_agg"));
    private final DriverContext driverContext;
    private final GroupingAggregatorFunction groupingAggregator;
    private final int inputChannel;
    private boolean receivedInput = false;

    public static List<IntermediateStateDesc> intermediateStateDesc() {
        return INTERMEDIATE_STATE_DESC;
    }

    public FromPartialAggregatorFunction(DriverContext driverContext, GroupingAggregatorFunction groupingAggregator, int inputChannel) {
        this.driverContext = driverContext;
        this.groupingAggregator = groupingAggregator;
        this.inputChannel = inputChannel;
    }

    @Override
    public void addRawInput(Page page) {
        this.addIntermediateInput(page);
    }

    @Override
    public void addIntermediateInput(Page page) {
        try (IntVector groupIds = this.driverContext.blockFactory().newConstantIntVector(0, page.getPositionCount());){
            if (page.getPositionCount() > 0) {
                this.receivedInput = true;
            }
            CompositeBlock inputBlock = (CompositeBlock)page.getBlock(this.inputChannel);
            this.groupingAggregator.addIntermediateInput(0, groupIds, inputBlock.asPage());
        }
    }

    private IntVector outputPositions() {
        return this.driverContext.blockFactory().newConstantIntVector(0, this.receivedInput ? 1 : 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void evaluateIntermediate(Block[] blocks, int offset, DriverContext driverContext) {
        Releasable[] partialBlocks = new Block[this.groupingAggregator.intermediateBlockCount()];
        boolean success = false;
        try (IntVector selected = this.outputPositions();){
            this.groupingAggregator.evaluateIntermediate((Block[])partialBlocks, 0, selected);
            blocks[offset] = new CompositeBlock((Block[])partialBlocks);
            success = true;
        }
        finally {
            if (!success) {
                Releasables.close((Releasable[])partialBlocks);
            }
        }
    }

    @Override
    public void evaluateFinal(Block[] blocks, int offset, DriverContext driverContext) {
        try (IntVector selected = this.outputPositions();){
            this.groupingAggregator.evaluateFinal(blocks, offset, selected, driverContext);
        }
    }

    @Override
    public int intermediateBlockCount() {
        return INTERMEDIATE_STATE_DESC.size();
    }

    public void close() {
        Releasables.close((Releasable)this.groupingAggregator);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[channel=" + this.inputChannel + ",delegate=" + this.groupingAggregator + "]";
    }
}

