/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.aggregation;

import org.elasticsearch.compute.aggregation.AggregatorState;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.operator.DriverContext;

final class FloatState
implements AggregatorState {
    private float value;
    private boolean seen;

    FloatState() {
        this(0.0f);
    }

    FloatState(float init) {
        this.value = init;
    }

    float floatValue() {
        return this.value;
    }

    void floatValue(float value) {
        this.value = value;
    }

    boolean seen() {
        return this.seen;
    }

    void seen(boolean seen) {
        this.seen = seen;
    }

    @Override
    public void toIntermediate(Block[] blocks, int offset, DriverContext driverContext) {
        assert (blocks.length >= offset + 2);
        blocks[offset + 0] = driverContext.blockFactory().newConstantFloatBlockWith(this.value, 1);
        blocks[offset + 1] = driverContext.blockFactory().newConstantBooleanBlockWith(this.seen, 1);
    }

    public void close() {
    }
}

