/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.repositories.blobstore.testkit;

import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefIterator;
import org.elasticsearch.common.bytes.AbstractBytesReference;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.repositories.blobstore.testkit.RandomBlobContent;

class RandomBlobContentBytesReference
extends AbstractBytesReference {
    private final RandomBlobContent randomBlobContent;

    RandomBlobContentBytesReference(RandomBlobContent randomBlobContent, int length) {
        super(length);
        assert (0 < length);
        this.randomBlobContent = randomBlobContent;
    }

    public byte get(int index) {
        return this.randomBlobContent.buffer[index % this.randomBlobContent.buffer.length];
    }

    public BytesReference slice(int from, int length) {
        assert (false) : "must not slice a RandomBlobContentBytesReference";
        throw new UnsupportedOperationException("RandomBlobContentBytesReference#slice(int, int) is unsupported");
    }

    public long ramBytesUsed() {
        return this.randomBlobContent.buffer.length;
    }

    public BytesRef toBytesRef() {
        assert (false) : "must not materialize a RandomBlobContentBytesReference";
        throw new UnsupportedOperationException("RandomBlobContentBytesReference#toBytesRef() is unsupported");
    }

    public BytesRefIterator iterator() {
        final byte[] buffer = this.randomBlobContent.buffer;
        final int lastBlock = (this.length - 1) / buffer.length;
        return new BytesRefIterator(){
            int nextBlock = 0;

            public BytesRef next() {
                int end;
                int block;
                if ((block = this.nextBlock++) > lastBlock) {
                    return null;
                }
                RandomBlobContentBytesReference.this.randomBlobContent.ensureNotCancelled(block * buffer.length + "/" + RandomBlobContentBytesReference.this.length);
                if (block == lastBlock) {
                    RandomBlobContentBytesReference.this.randomBlobContent.onLastRead();
                    end = (RandomBlobContentBytesReference.this.length - 1) % buffer.length + 1;
                } else {
                    end = buffer.length;
                }
                return new BytesRef(buffer, 0, end);
            }
        };
    }
}

