/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.deprecation;

import java.io.IOException;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.support.nodes.BaseNodeResponse;
import org.elasticsearch.action.support.nodes.TransportNodesAction;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.transport.TransportRequest;
import org.elasticsearch.xpack.core.deprecation.DeprecationIssue;
import org.elasticsearch.xpack.deprecation.NodesDeprecationCheckResponse;

public class NodesDeprecationCheckAction
extends ActionType<NodesDeprecationCheckResponse> {
    public static final NodesDeprecationCheckAction INSTANCE = new NodesDeprecationCheckAction();
    public static final String NAME = "cluster:admin/xpack/deprecation/nodes/info";

    private NodesDeprecationCheckAction() {
        super(NAME);
    }

    public static class NodeResponse
    extends BaseNodeResponse {
        private final List<DeprecationIssue> deprecationIssues;

        public NodeResponse(StreamInput in) throws IOException {
            super(in);
            this.deprecationIssues = in.readCollectionAsList(DeprecationIssue::new);
        }

        public NodeResponse(DiscoveryNode node, List<DeprecationIssue> deprecationIssues) {
            super(node);
            this.deprecationIssues = deprecationIssues;
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeCollection(this.deprecationIssues);
        }

        public List<DeprecationIssue> getDeprecationIssues() {
            return this.deprecationIssues;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            NodeResponse that = (NodeResponse)((Object)o);
            return Objects.equals(this.getDeprecationIssues(), that.getDeprecationIssues()) && Objects.equals(this.getNode(), that.getNode());
        }

        public int hashCode() {
            return Objects.hash(this.getNode(), this.getDeprecationIssues());
        }
    }

    public static class NodeRequest
    extends TransportRequest {
        public NodeRequest() {
        }

        public NodeRequest(StreamInput in) throws IOException {
            super(in);
            TransportNodesAction.skipLegacyNodesRequestHeader((TransportVersion)TransportVersions.DROP_UNUSED_NODES_REQUESTS, (StreamInput)in);
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            TransportNodesAction.sendLegacyNodesRequestHeader((TransportVersion)TransportVersions.DROP_UNUSED_NODES_REQUESTS, (StreamOutput)out);
        }
    }
}

