/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.searchablesnapshots.action.cache;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.function.Supplier;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.FailedNodeException;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.TransportAction;
import org.elasticsearch.action.support.nodes.BaseNodeResponse;
import org.elasticsearch.action.support.nodes.BaseNodesRequest;
import org.elasticsearch.action.support.nodes.BaseNodesResponse;
import org.elasticsearch.action.support.nodes.TransportNodesAction;
import org.elasticsearch.blobcache.shared.SharedBlobCacheService;
import org.elasticsearch.cluster.ClusterName;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportRequest;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentFragment;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.searchablesnapshots.SearchableSnapshots;
import org.elasticsearch.xpack.searchablesnapshots.cache.common.CacheKey;

public class TransportSearchableSnapshotsNodeCachesStatsAction
extends TransportNodesAction<NodesRequest, NodesCachesStatsResponse, NodeRequest, NodeCachesStatsResponse> {
    public static final String ACTION_NAME = "cluster:admin/xpack/searchable_snapshots/cache/stats";
    public static final ActionType<NodesCachesStatsResponse> TYPE = new ActionType("cluster:admin/xpack/searchable_snapshots/cache/stats");
    private final Supplier<SharedBlobCacheService<CacheKey>> frozenCacheService;
    private final XPackLicenseState licenseState;

    @Inject
    public TransportSearchableSnapshotsNodeCachesStatsAction(ThreadPool threadPool, ClusterService clusterService, TransportService transportService, ActionFilters actionFilters, SearchableSnapshots.FrozenCacheServiceSupplier frozenCacheService, XPackLicenseState licenseState) {
        super(ACTION_NAME, clusterService, transportService, actionFilters, NodeRequest::new, (Executor)threadPool.executor("management"));
        this.frozenCacheService = frozenCacheService;
        this.licenseState = licenseState;
    }

    protected NodesCachesStatsResponse newResponse(NodesRequest request, List<NodeCachesStatsResponse> responses, List<FailedNodeException> failures) {
        return new NodesCachesStatsResponse(this.clusterService.getClusterName(), responses, failures);
    }

    protected NodeRequest newNodeRequest(NodesRequest request) {
        return new NodeRequest();
    }

    protected NodeCachesStatsResponse newNodeResponse(StreamInput in, DiscoveryNode node) throws IOException {
        return new NodeCachesStatsResponse(in);
    }

    protected DiscoveryNode[] resolveRequest(NodesRequest request, ClusterState clusterState) {
        Map dataNodes = clusterState.getNodes().getDataNodes();
        DiscoveryNode[] resolvedNodes = request.nodesIds() == null || request.nodesIds().length == 0 ? (DiscoveryNode[])dataNodes.values().toArray(DiscoveryNode[]::new) : (DiscoveryNode[])Arrays.stream(request.nodesIds()).filter(dataNodes::containsKey).map(dataNodes::get).toArray(DiscoveryNode[]::new);
        return resolvedNodes;
    }

    protected NodeCachesStatsResponse nodeOperation(NodeRequest request, Task task) {
        SearchableSnapshots.ensureValidLicense(this.licenseState);
        SharedBlobCacheService.Stats frozenCacheStats = this.frozenCacheService.get() != null ? this.frozenCacheService.get().getStats() : SharedBlobCacheService.Stats.EMPTY;
        return new NodeCachesStatsResponse(this.clusterService.localNode(), frozenCacheStats.numberOfRegions(), frozenCacheStats.size(), frozenCacheStats.regionSize(), frozenCacheStats.writeCount(), frozenCacheStats.writeBytes(), frozenCacheStats.readCount(), frozenCacheStats.readBytes(), frozenCacheStats.evictCount());
    }

    public static class NodesCachesStatsResponse
    extends BaseNodesResponse<NodeCachesStatsResponse>
    implements ToXContentObject {
        public NodesCachesStatsResponse(ClusterName clusterName, List<NodeCachesStatsResponse> nodes, List<FailedNodeException> failures) {
            super(clusterName, nodes, failures);
        }

        protected List<NodeCachesStatsResponse> readNodesFrom(StreamInput in) {
            return (List)TransportAction.localOnly();
        }

        protected void writeNodesTo(StreamOutput out, List<NodeCachesStatsResponse> nodes) {
            TransportAction.localOnly();
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.startObject("nodes");
            for (NodeCachesStatsResponse node : this.getNodes()) {
                node.toXContent(builder, params);
            }
            builder.endObject();
            builder.endObject();
            return builder;
        }
    }

    public static final class NodeRequest
    extends TransportRequest {
        public NodeRequest() {
        }

        public NodeRequest(StreamInput in) throws IOException {
            super(in);
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
        }
    }

    public static class NodeCachesStatsResponse
    extends BaseNodeResponse
    implements ToXContentFragment {
        private final int numRegions;
        private final long size;
        private final long regionSize;
        private final long writes;
        private final long bytesWritten;
        private final long reads;
        private final long bytesRead;
        private final long evictions;

        public NodeCachesStatsResponse(DiscoveryNode node, int numRegions, long size, long regionSize, long writes, long bytesWritten, long reads, long bytesRead, long evictions) {
            super(node);
            this.numRegions = numRegions;
            this.size = size;
            this.regionSize = regionSize;
            this.writes = writes;
            this.bytesWritten = bytesWritten;
            this.reads = reads;
            this.bytesRead = bytesRead;
            this.evictions = evictions;
        }

        public NodeCachesStatsResponse(StreamInput in) throws IOException {
            super(in);
            this.numRegions = in.readVInt();
            this.size = in.readVLong();
            this.regionSize = in.readVLong();
            this.writes = in.readVLong();
            this.bytesWritten = in.readVLong();
            this.reads = in.readVLong();
            this.bytesRead = in.readVLong();
            this.evictions = in.readVLong();
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeVInt(this.numRegions);
            out.writeVLong(this.size);
            out.writeVLong(this.regionSize);
            out.writeVLong(this.writes);
            out.writeVLong(this.bytesWritten);
            out.writeVLong(this.reads);
            out.writeVLong(this.bytesRead);
            out.writeVLong(this.evictions);
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject(this.getNode().getId());
            builder.startObject("shared_cache");
            builder.field("reads", this.reads);
            builder.humanReadableField("bytes_read_in_bytes", "bytes_read", (Object)ByteSizeValue.ofBytes((long)this.bytesRead));
            builder.field("writes", this.writes);
            builder.humanReadableField("bytes_written_in_bytes", "bytes_written", (Object)ByteSizeValue.ofBytes((long)this.bytesWritten));
            builder.field("evictions", this.evictions);
            builder.field("num_regions", this.numRegions);
            builder.humanReadableField("size_in_bytes", "size", (Object)ByteSizeValue.ofBytes((long)this.size));
            builder.humanReadableField("region_size_in_bytes", "region_size", (Object)ByteSizeValue.ofBytes((long)this.regionSize));
            builder.endObject();
            builder.endObject();
            return builder;
        }

        public int getNumRegions() {
            return this.numRegions;
        }

        public long getSize() {
            return this.size;
        }

        public long getRegionSize() {
            return this.regionSize;
        }

        public long getWrites() {
            return this.writes;
        }

        public long getBytesWritten() {
            return this.bytesWritten;
        }

        public long getReads() {
            return this.reads;
        }

        public long getBytesRead() {
            return this.bytesRead;
        }

        public long getEvictions() {
            return this.evictions;
        }
    }

    public static final class NodesRequest
    extends BaseNodesRequest<NodesRequest> {
        public NodesRequest(String[] nodes) {
            super(nodes);
        }
    }
}

