/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.aggregations.bucket.histogram;

import java.io.IOException;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.LongToIntFunction;
import java.util.function.LongUnaryOperator;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.index.SortedNumericDocValues;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.util.CollectionUtil;
import org.elasticsearch.aggregations.bucket.histogram.AutoDateHistogramAggregationBuilder;
import org.elasticsearch.aggregations.bucket.histogram.InternalAutoDateHistogram;
import org.elasticsearch.common.Rounding;
import org.elasticsearch.common.util.ByteArray;
import org.elasticsearch.common.util.IntArray;
import org.elasticsearch.common.util.LongArray;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.search.DocValueFormat;
import org.elasticsearch.search.aggregations.AggregationExecutionContext;
import org.elasticsearch.search.aggregations.Aggregator;
import org.elasticsearch.search.aggregations.AggregatorFactories;
import org.elasticsearch.search.aggregations.BucketOrder;
import org.elasticsearch.search.aggregations.CardinalityUpperBound;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.LeafBucketCollector;
import org.elasticsearch.search.aggregations.LeafBucketCollectorBase;
import org.elasticsearch.search.aggregations.bucket.BestBucketsDeferringCollector;
import org.elasticsearch.search.aggregations.bucket.DeferableBucketAggregator;
import org.elasticsearch.search.aggregations.bucket.DeferringBucketCollector;
import org.elasticsearch.search.aggregations.bucket.terms.LongKeyedBucketOrds;
import org.elasticsearch.search.aggregations.support.AggregationContext;
import org.elasticsearch.search.aggregations.support.ValuesSource;
import org.elasticsearch.search.aggregations.support.ValuesSourceConfig;

abstract class AutoDateHistogramAggregator
extends DeferableBucketAggregator {
    private final ValuesSource.Numeric valuesSource;
    private final DocValueFormat formatter;
    private final Function<Rounding, Rounding.Prepared> roundingPreparer;
    private BestBucketsDeferringCollector deferringCollector;
    protected final AutoDateHistogramAggregationBuilder.RoundingInfo[] roundingInfos;
    protected final int targetBuckets;

    static AutoDateHistogramAggregator build(String name, AggregatorFactories factories, int targetBuckets, AutoDateHistogramAggregationBuilder.RoundingInfo[] roundingInfos, ValuesSourceConfig valuesSourceConfig, AggregationContext context, Aggregator parent, CardinalityUpperBound cardinality, Map<String, Object> metadata) throws IOException {
        return cardinality == CardinalityUpperBound.ONE ? new FromSingle(name, factories, targetBuckets, roundingInfos, valuesSourceConfig, context, parent, metadata) : new FromMany(name, factories, targetBuckets, roundingInfos, valuesSourceConfig, context, parent, metadata);
    }

    private AutoDateHistogramAggregator(String name, AggregatorFactories factories, int targetBuckets, AutoDateHistogramAggregationBuilder.RoundingInfo[] roundingInfos, ValuesSourceConfig valuesSourceConfig, AggregationContext context, Aggregator parent, Map<String, Object> metadata) throws IOException {
        super(name, factories, context, parent, metadata);
        this.targetBuckets = targetBuckets;
        this.valuesSource = valuesSourceConfig.hasValues() ? (ValuesSource.Numeric)valuesSourceConfig.getValuesSource() : null;
        this.formatter = valuesSourceConfig.format();
        this.roundingInfos = roundingInfos;
        this.roundingPreparer = valuesSourceConfig.roundingPreparer(context);
    }

    public final ScoreMode scoreMode() {
        if (this.valuesSource != null && this.valuesSource.needsScores()) {
            return ScoreMode.COMPLETE;
        }
        return super.scoreMode();
    }

    protected final boolean shouldDefer(Aggregator aggregator) {
        return true;
    }

    public final DeferringBucketCollector buildDeferringCollector() {
        this.deferringCollector = new BestBucketsDeferringCollector(this.topLevelQuery(), this.searcher(), AutoDateHistogramAggregator.descendsFromGlobalAggregator((Aggregator)this.parent()));
        return this.deferringCollector;
    }

    protected abstract LeafBucketCollector getLeafCollector(SortedNumericDocValues var1, LeafBucketCollector var2) throws IOException;

    protected abstract LeafBucketCollector getLeafCollector(NumericDocValues var1, LeafBucketCollector var2) throws IOException;

    public final LeafBucketCollector getLeafCollector(AggregationExecutionContext aggCtx, LeafBucketCollector sub) throws IOException {
        if (this.valuesSource == null) {
            return LeafBucketCollector.NO_OP_COLLECTOR;
        }
        SortedNumericDocValues values = this.valuesSource.longValues(aggCtx.getLeafReaderContext());
        NumericDocValues singleton = DocValues.unwrapSingleton((SortedNumericDocValues)values);
        return singleton != null ? this.getLeafCollector(singleton, sub) : this.getLeafCollector(values, sub);
    }

    protected final InternalAggregation[] buildAggregations(LongKeyedBucketOrds bucketOrds, LongToIntFunction roundingIndexFor, long[] owningBucketOrds) throws IOException {
        return this.buildAggregationsForVariableBuckets(owningBucketOrds, bucketOrds, (bucketValue, docCount, subAggregationResults) -> new InternalAutoDateHistogram.Bucket(bucketValue, docCount, this.formatter, subAggregationResults), (owningBucketOrd, buckets) -> {
            CollectionUtil.introSort((List)buckets, (Comparator)BucketOrder.key((boolean)true).comparator());
            InternalAutoDateHistogram.BucketInfo emptyBucketInfo = new InternalAutoDateHistogram.BucketInfo(this.roundingInfos, roundingIndexFor.applyAsInt(owningBucketOrd), this.buildEmptySubAggregations());
            return new InternalAutoDateHistogram(this.name, buckets, this.targetBuckets, emptyBucketInfo, this.formatter, this.metadata(), 1L);
        });
    }

    public final InternalAggregation buildEmptyAggregation() {
        InternalAutoDateHistogram.BucketInfo emptyBucketInfo = new InternalAutoDateHistogram.BucketInfo(this.roundingInfos, 0, this.buildEmptySubAggregations());
        return new InternalAutoDateHistogram(this.name, Collections.emptyList(), this.targetBuckets, emptyBucketInfo, this.formatter, this.metadata(), 1L);
    }

    protected final Rounding.Prepared prepareRounding(int index) {
        return this.roundingPreparer.apply(this.roundingInfos[index].rounding);
    }

    protected final void merge(long[] mergeMap, long newNumBuckets) {
        LongUnaryOperator howToRewrite = b -> mergeMap[(int)b];
        this.rewriteBuckets(newNumBuckets, howToRewrite);
        if (this.deferringCollector != null) {
            this.deferringCollector.rewriteBuckets(howToRewrite);
        }
    }

    private static class FromSingle
    extends AutoDateHistogramAggregator {
        private int roundingIdx;
        private Rounding.Prepared preparedRounding;
        private LongKeyedBucketOrds.FromSingle bucketOrds;
        private long min = Long.MAX_VALUE;
        private long max = Long.MIN_VALUE;

        FromSingle(String name, AggregatorFactories factories, int targetBuckets, AutoDateHistogramAggregationBuilder.RoundingInfo[] roundingInfos, ValuesSourceConfig valuesSourceConfig, AggregationContext context, Aggregator parent, Map<String, Object> metadata) throws IOException {
            super(name, factories, targetBuckets, roundingInfos, valuesSourceConfig, context, parent, metadata);
            this.preparedRounding = this.prepareRounding(0);
            this.bucketOrds = new LongKeyedBucketOrds.FromSingle(this.bigArrays());
        }

        @Override
        protected LeafBucketCollector getLeafCollector(final SortedNumericDocValues values, final LeafBucketCollector sub) {
            return new LeafBucketCollectorBase(sub, values){

                public void collect(int doc, long owningBucketOrd) throws IOException {
                    assert (owningBucketOrd == 0L);
                    if (!values.advanceExact(doc)) {
                        return;
                    }
                    int valuesCount = values.docValueCount();
                    long previousRounded = Long.MIN_VALUE;
                    for (int i = 0; i < valuesCount; ++i) {
                        long value = values.nextValue();
                        long rounded = preparedRounding.round(value);
                        assert (rounded >= previousRounded);
                        if (rounded == previousRounded) continue;
                        this.collectValue(doc, rounded, sub);
                        previousRounded = rounded;
                    }
                }
            };
        }

        @Override
        protected LeafBucketCollector getLeafCollector(final NumericDocValues values, final LeafBucketCollector sub) {
            return new LeafBucketCollectorBase(sub, values){

                public void collect(int doc, long owningBucketOrd) throws IOException {
                    assert (owningBucketOrd == 0L);
                    if (values.advanceExact(doc)) {
                        this.collectValue(doc, preparedRounding.round(values.longValue()), sub);
                    }
                }
            };
        }

        private void collectValue(int doc, long rounded, LeafBucketCollector sub) throws IOException {
            long bucketOrd = this.bucketOrds.add(0L, rounded);
            if (bucketOrd < 0L) {
                bucketOrd = -1L - bucketOrd;
                this.collectExistingBucket(sub, doc, bucketOrd);
                return;
            }
            this.collectBucket(sub, doc, bucketOrd);
            this.increaseRoundingIfNeeded(rounded);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void increaseRoundingIfNeeded(long rounded) {
            if (this.roundingIdx >= this.roundingInfos.length - 1) {
                return;
            }
            this.min = Math.min(this.min, rounded);
            this.max = Math.max(this.max, rounded);
            if (this.bucketOrds.size() <= (long)(this.targetBuckets * this.roundingInfos[this.roundingIdx].getMaximumInnerInterval()) && this.max - this.min <= (long)this.targetBuckets * this.roundingInfos[this.roundingIdx].getMaximumRoughEstimateDurationMillis()) {
                return;
            }
            do {
                LongKeyedBucketOrds.FromSingle oldOrds = this.bucketOrds;
                boolean success = false;
                try {
                    this.preparedRounding = this.prepareRounding(++this.roundingIdx);
                    long[] mergeMap = new long[Math.toIntExact(oldOrds.size())];
                    this.bucketOrds = new LongKeyedBucketOrds.FromSingle(this.bigArrays());
                    success = true;
                    LongKeyedBucketOrds.BucketOrdsEnum ordsEnum = oldOrds.ordsEnum(0L);
                    while (ordsEnum.next()) {
                        long oldKey = ordsEnum.value();
                        long newKey = this.preparedRounding.round(oldKey);
                        long newBucketOrd = this.bucketOrds.add(0L, newKey);
                        mergeMap[(int)ordsEnum.ord()] = newBucketOrd >= 0L ? newBucketOrd : -1L - newBucketOrd;
                    }
                    this.merge(mergeMap, this.bucketOrds.size());
                }
                finally {
                    if (success) {
                        oldOrds.close();
                    }
                }
            } while (this.roundingIdx < this.roundingInfos.length - 1 && (this.bucketOrds.size() > (long)(this.targetBuckets * this.roundingInfos[this.roundingIdx].getMaximumInnerInterval()) || this.max - this.min > (long)this.targetBuckets * this.roundingInfos[this.roundingIdx].getMaximumRoughEstimateDurationMillis()));
        }

        public InternalAggregation[] buildAggregations(long[] owningBucketOrds) throws IOException {
            return this.buildAggregations((LongKeyedBucketOrds)this.bucketOrds, l -> this.roundingIdx, owningBucketOrds);
        }

        public void collectDebugInfo(BiConsumer<String, Object> add) {
            super.collectDebugInfo(add);
            add.accept("surviving_buckets", this.bucketOrds.size());
        }

        protected void doClose() {
            Releasables.close((Releasable)this.bucketOrds);
        }
    }

    private static class FromMany
    extends AutoDateHistogramAggregator {
        private final Rounding.Prepared[] preparedRoundings;
        private LongKeyedBucketOrds.FromMany bucketOrds;
        private ByteArray roundingIndices;
        private LongArray mins;
        private LongArray maxes;
        private IntArray liveBucketCountUnderestimate;
        private long wastedBucketsOverestimate = 0L;
        private long nextRebucketAt = 1000L;
        private int rebucketCount = 0;

        FromMany(String name, AggregatorFactories factories, int targetBuckets, AutoDateHistogramAggregationBuilder.RoundingInfo[] roundingInfos, ValuesSourceConfig valuesSourceConfig, AggregationContext context, Aggregator parent, Map<String, Object> metadata) throws IOException {
            super(name, factories, targetBuckets, roundingInfos, valuesSourceConfig, context, parent, metadata);
            assert (roundingInfos.length < 127) : "Rounding must fit in a signed byte";
            this.roundingIndices = this.bigArrays().newByteArray(1L, true);
            this.mins = this.bigArrays().newLongArray(1L, false);
            this.mins.set(0L, Long.MAX_VALUE);
            this.maxes = this.bigArrays().newLongArray(1L, false);
            this.maxes.set(0L, Long.MIN_VALUE);
            this.preparedRoundings = new Rounding.Prepared[roundingInfos.length];
            this.preparedRoundings[0] = this.prepareRounding(0);
            this.bucketOrds = new LongKeyedBucketOrds.FromMany(this.bigArrays());
            this.liveBucketCountUnderestimate = this.bigArrays().newIntArray(1L, true);
        }

        @Override
        protected LeafBucketCollector getLeafCollector(final SortedNumericDocValues values, final LeafBucketCollector sub) {
            return new LeafBucketCollectorBase(sub, values){

                public void collect(int doc, long owningBucketOrd) throws IOException {
                    if (!values.advanceExact(doc)) {
                        return;
                    }
                    int valuesCount = values.docValueCount();
                    long previousRounded = Long.MIN_VALUE;
                    int roundingIdx = this.roundingIndexFor(owningBucketOrd);
                    for (int i = 0; i < valuesCount; ++i) {
                        long value = values.nextValue();
                        long rounded = preparedRoundings[roundingIdx].round(value);
                        assert (rounded >= previousRounded);
                        if (rounded == previousRounded) continue;
                        roundingIdx = this.collectValue(owningBucketOrd, roundingIdx, doc, rounded, sub);
                        previousRounded = rounded;
                    }
                }
            };
        }

        @Override
        protected LeafBucketCollector getLeafCollector(final NumericDocValues values, final LeafBucketCollector sub) {
            return new LeafBucketCollectorBase(sub, values){

                public void collect(int doc, long owningBucketOrd) throws IOException {
                    if (values.advanceExact(doc)) {
                        int roundingIdx = this.roundingIndexFor(owningBucketOrd);
                        long rounded = preparedRoundings[roundingIdx].round(values.longValue());
                        this.collectValue(owningBucketOrd, roundingIdx, doc, rounded, sub);
                    }
                }
            };
        }

        private int collectValue(long owningBucketOrd, int roundingIdx, int doc, long rounded, LeafBucketCollector sub) throws IOException {
            long bucketOrd = this.bucketOrds.add(owningBucketOrd, rounded);
            if (bucketOrd < 0L) {
                bucketOrd = -1L - bucketOrd;
                this.collectExistingBucket(sub, doc, bucketOrd);
                return roundingIdx;
            }
            this.collectBucket(sub, doc, bucketOrd);
            this.liveBucketCountUnderestimate = this.bigArrays().grow(this.liveBucketCountUnderestimate, owningBucketOrd + 1L);
            int estimatedBucketCount = this.liveBucketCountUnderestimate.increment(owningBucketOrd, 1);
            return this.increaseRoundingIfNeeded(owningBucketOrd, estimatedBucketCount, rounded, roundingIdx);
        }

        private int increaseRoundingIfNeeded(long owningBucketOrd, int oldEstimatedBucketCount, long newKey, int oldRounding) {
            int newEstimatedBucketCount;
            long oldSize;
            if (oldRounding >= this.roundingInfos.length - 1) {
                return oldRounding;
            }
            if (this.mins.size() < owningBucketOrd + 1L) {
                oldSize = this.mins.size();
                this.mins = this.bigArrays().grow(this.mins, owningBucketOrd + 1L);
                this.mins.fill(oldSize, this.mins.size(), Long.MAX_VALUE);
            }
            if (this.maxes.size() < owningBucketOrd + 1L) {
                oldSize = this.maxes.size();
                this.maxes = this.bigArrays().grow(this.maxes, owningBucketOrd + 1L);
                this.maxes.fill(oldSize, this.maxes.size(), Long.MIN_VALUE);
            }
            long min = Math.min(this.mins.get(owningBucketOrd), newKey);
            this.mins.set(owningBucketOrd, min);
            long max = Math.max(this.maxes.get(owningBucketOrd), newKey);
            this.maxes.set(owningBucketOrd, max);
            if (oldEstimatedBucketCount <= this.targetBuckets * this.roundingInfos[oldRounding].getMaximumInnerInterval() && max - min <= (long)this.targetBuckets * this.roundingInfos[oldRounding].getMaximumRoughEstimateDurationMillis()) {
                return oldRounding;
            }
            long oldRoughDuration = this.roundingInfos[oldRounding].roughEstimateDurationMillis;
            int newRounding = oldRounding;
            do {
                double ratio = (double)oldRoughDuration / (double)this.roundingInfos[++newRounding].getRoughEstimateDurationMillis();
                newEstimatedBucketCount = (int)Math.ceil((double)oldEstimatedBucketCount * ratio);
            } while (newRounding < this.roundingInfos.length - 1 && (newEstimatedBucketCount > this.targetBuckets * this.roundingInfos[newRounding].getMaximumInnerInterval() || max - min > (long)this.targetBuckets * this.roundingInfos[newRounding].getMaximumRoughEstimateDurationMillis()));
            this.setRounding(owningBucketOrd, newRounding);
            this.mins.set(owningBucketOrd, this.preparedRoundings[newRounding].round(this.mins.get(owningBucketOrd)));
            this.maxes.set(owningBucketOrd, this.preparedRoundings[newRounding].round(this.maxes.get(owningBucketOrd)));
            this.wastedBucketsOverestimate += (long)(oldEstimatedBucketCount - newEstimatedBucketCount);
            if (this.wastedBucketsOverestimate > this.nextRebucketAt) {
                this.rebucket();
                this.wastedBucketsOverestimate = 0L;
                this.nextRebucketAt *= 2L;
            } else {
                this.liveBucketCountUnderestimate.set(owningBucketOrd, newEstimatedBucketCount);
            }
            return newRounding;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void rebucket() {
            ++this.rebucketCount;
            LongKeyedBucketOrds.FromMany oldOrds = this.bucketOrds;
            boolean success = false;
            try {
                long[] mergeMap = new long[Math.toIntExact(oldOrds.size())];
                this.bucketOrds = new LongKeyedBucketOrds.FromMany(this.bigArrays());
                success = true;
                for (long owningBucketOrd = 0L; owningBucketOrd <= oldOrds.maxOwningBucketOrd(); ++owningBucketOrd) {
                    LongKeyedBucketOrds.BucketOrdsEnum ordsEnum = oldOrds.ordsEnum(owningBucketOrd);
                    Rounding.Prepared preparedRounding = this.preparedRoundings[this.roundingIndexFor(owningBucketOrd)];
                    while (ordsEnum.next()) {
                        long oldKey = ordsEnum.value();
                        long newKey = preparedRounding.round(oldKey);
                        long newBucketOrd = this.bucketOrds.add(owningBucketOrd, newKey);
                        mergeMap[(int)ordsEnum.ord()] = newBucketOrd >= 0L ? newBucketOrd : -1L - newBucketOrd;
                    }
                    this.liveBucketCountUnderestimate = this.bigArrays().grow(this.liveBucketCountUnderestimate, owningBucketOrd + 1L);
                    this.liveBucketCountUnderestimate.set(owningBucketOrd, Math.toIntExact(this.bucketOrds.bucketsInOrd(owningBucketOrd)));
                }
                this.merge(mergeMap, this.bucketOrds.size());
            }
            finally {
                if (success) {
                    oldOrds.close();
                }
            }
        }

        public InternalAggregation[] buildAggregations(long[] owningBucketOrds) throws IOException {
            this.rebucket();
            return this.buildAggregations((LongKeyedBucketOrds)this.bucketOrds, this::roundingIndexFor, owningBucketOrds);
        }

        public void collectDebugInfo(BiConsumer<String, Object> add) {
            super.collectDebugInfo(add);
            add.accept("surviving_buckets", this.bucketOrds.size());
            add.accept("wasted_buckets_overestimate", this.wastedBucketsOverestimate);
            add.accept("next_rebucket_at", this.nextRebucketAt);
            add.accept("rebucket_count", this.rebucketCount);
        }

        private void setRounding(long owningBucketOrd, int newRounding) {
            this.roundingIndices = this.bigArrays().grow(this.roundingIndices, owningBucketOrd + 1L);
            this.roundingIndices.set(owningBucketOrd, (byte)newRounding);
            if (this.preparedRoundings[newRounding] == null) {
                this.preparedRoundings[newRounding] = this.prepareRounding(newRounding);
            }
        }

        private int roundingIndexFor(long owningBucketOrd) {
            return owningBucketOrd < this.roundingIndices.size() ? (int)this.roundingIndices.get(owningBucketOrd) : 0;
        }

        public void doClose() {
            Releasables.close((Releasable[])new Releasable[]{this.bucketOrds, this.roundingIndices, this.mins, this.maxes, this.liveBucketCountUnderestimate});
        }
    }
}

