/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.eql.execution.sample;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.util.Accountable;
import org.apache.lucene.util.RamUsageEstimator;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.search.MultiSearchResponse;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.breaker.CircuitBreaker;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.SearchHits;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.bucket.composite.InternalComposite;
import org.elasticsearch.xpack.eql.EqlIllegalArgumentException;
import org.elasticsearch.xpack.eql.execution.assembler.Executable;
import org.elasticsearch.xpack.eql.execution.assembler.SampleCriterion;
import org.elasticsearch.xpack.eql.execution.assembler.SampleQueryRequest;
import org.elasticsearch.xpack.eql.execution.sample.Sample;
import org.elasticsearch.xpack.eql.execution.sample.SamplePayload;
import org.elasticsearch.xpack.eql.execution.search.HitReference;
import org.elasticsearch.xpack.eql.execution.search.Limit;
import org.elasticsearch.xpack.eql.execution.search.QueryClient;
import org.elasticsearch.xpack.eql.execution.search.RuntimeUtils;
import org.elasticsearch.xpack.eql.execution.sequence.SequenceKey;
import org.elasticsearch.xpack.eql.session.EmptyPayload;
import org.elasticsearch.xpack.eql.session.Payload;
import org.elasticsearch.xpack.ql.util.ActionListeners;

public class SampleIterator
implements Executable {
    private static final Logger log = LogManager.getLogger(SampleIterator.class);
    private final QueryClient client;
    private final List<SampleCriterion> criteria;
    final Stack<Page> stack = new Stack();
    private final int maxCriteria;
    final List<Sample> samples;
    private final int fetchSize;
    private final Limit limit;
    private final int maxSamplesPerKey;
    private long startTime;
    protected static final int CB_STACK_SIZE_PRECISION = 1000;
    private static final String CB_COMPLETED_LABEL = "sample_completed";
    private static final String CB_INFLIGHT_LABEL = "sample_inflight";
    private final CircuitBreaker circuitBreaker;
    private long samplesRamBytesUsed = 0L;
    private long stackRamBytesUsed = 0L;
    private long totalRamBytesUsed = 0L;
    private long totalPageSize = 0L;
    private long previousTotalPageSize = 0L;

    public SampleIterator(QueryClient client, List<SampleCriterion> criteria, int fetchSize, Limit limit, CircuitBreaker circuitBreaker, int maxSamplesPerKey) {
        this.client = client;
        this.criteria = criteria;
        this.maxCriteria = criteria.size();
        this.fetchSize = fetchSize;
        this.samples = new ArrayList<Sample>();
        this.limit = limit;
        this.circuitBreaker = circuitBreaker;
        this.maxSamplesPerKey = maxSamplesPerKey;
    }

    @Override
    public void execute(ActionListener<Payload> listener) {
        this.startTime = System.currentTimeMillis();
        this.advance((ActionListener<Payload>)ActionListener.runAfter(listener, () -> {
            this.stack.clear();
            this.samples.clear();
            this.clearCircuitBreaker();
            this.client.close((ActionListener<Boolean>)listener.delegateFailure((l, r) -> {}));
        }));
    }

    private void advance(ActionListener<Payload> listener) {
        int currentCriterion = this.stack.size();
        if (currentCriterion < this.maxCriteria) {
            SampleQueryRequest request;
            log.trace("Advancing from step [{}]", (Object)currentCriterion);
            SampleCriterion criterion = this.criteria.get(currentCriterion);
            if (currentCriterion > 0) {
                request = criterion.midQuery();
                Page previousResults = this.stack.peek();
                SampleCriterion previousCriterion = this.criteria.get(currentCriterion - 1);
                request.multipleKeyPairs(previousCriterion.keys(previousResults.hits), previousResults.keys);
            } else {
                request = criterion.firstQuery();
            }
            log.trace("Querying step [{}] {}", (Object)currentCriterion, (Object)request);
            this.queryForCompositeAggPage(listener, request);
        } else {
            if (currentCriterion > this.maxCriteria) {
                throw new EqlIllegalArgumentException("Unexpected step [{}], max steps in this sample [{}]", currentCriterion, this.maxCriteria);
            }
            this.finalStep(listener);
        }
    }

    private void queryForCompositeAggPage(ActionListener<Payload> listener, SampleQueryRequest request) {
        this.client.query(request, (ActionListener<SearchResponse>)listener.delegateFailureAndWrap((delegate, r) -> {
            if (!r.hasAggregations()) {
                this.payload((ActionListener<Payload>)delegate);
                return;
            }
            InternalAggregation a = r.getAggregations().get("keys");
            if (!(a instanceof InternalComposite)) {
                throw new EqlIllegalArgumentException("Unexpected aggregation result type returned [{}]", a.getClass());
            }
            InternalComposite composite = (InternalComposite)a;
            log.trace("Found [{}] composite buckets", (Object)composite.getBuckets().size());
            Page nextPage = new Page(composite, request);
            if (nextPage.size > 0) {
                this.pushToStack(nextPage);
                this.advance((ActionListener<Payload>)delegate);
            } else if (this.stack.size() > 0) {
                this.nextPage((ActionListener<Payload>)delegate, this.stack.pop());
            } else {
                this.payload((ActionListener<Payload>)delegate);
            }
        }));
    }

    protected void pushToStack(Page nextPage) {
        this.stack.push(nextPage);
        this.totalPageSize += (long)nextPage.size;
        if (this.totalPageSize - this.previousTotalPageSize >= 1000L) {
            this.updateMemoryUsage();
            this.previousTotalPageSize = this.totalPageSize;
        }
    }

    private void finalStep(ActionListener<Payload> listener) {
        log.trace("Final step...");
        Page page = this.stack.pop();
        ArrayList<SearchRequest> searches = new ArrayList<SearchRequest>(this.maxCriteria * page.hits.size());
        ArrayList<SequenceKey> sampleKeys = new ArrayList<SequenceKey>();
        List<List<Object>> allCompositeKeyValues = this.criteria.get(this.maxCriteria - 1).keyValues(page.hits);
        for (List<Object> compositeKeyValues : allCompositeKeyValues) {
            for (SampleCriterion criterion : this.criteria) {
                SampleQueryRequest r2 = criterion.finalQuery();
                r2.singleKeyPair(compositeKeyValues, this.maxCriteria, this.maxSamplesPerKey);
                searches.add(RuntimeUtils.prepareRequest(r2.searchSource(), false, Strings.EMPTY_ARRAY));
            }
            sampleKeys.add(new SequenceKey(compositeKeyValues.toArray()));
        }
        int initialSize = this.samples.size();
        this.client.multiQuery(searches, (ActionListener<MultiSearchResponse>)listener.delegateFailureAndWrap((delegate, r) -> {
            ArrayList<List<Object>> sample = new ArrayList<List<SearchHit>>(this.maxCriteria);
            MultiSearchResponse.Item[] response = r.getResponses();
            int docGroupsCounter = 1;
            for (int responseIndex = 0; responseIndex < response.length; ++responseIndex) {
                MultiSearchResponse.Item item = response[responseIndex];
                SearchHits hits = item.getResponse().getHits();
                if (hits.getHits().length > 0) {
                    sample.add(Arrays.asList(hits.getHits()));
                }
                if (docGroupsCounter == this.maxCriteria) {
                    List<List<SearchHit>> matches = SampleIterator.matchSamples(sample, this.maxCriteria, this.maxSamplesPerKey);
                    for (List<SearchHit> match : matches) {
                        if (this.samples.size() < this.limit.limit()) {
                            this.samples.add(new Sample((SequenceKey)sampleKeys.get(responseIndex / this.maxCriteria), match));
                        }
                        if (this.samples.size() != this.limit.limit()) continue;
                        this.payload((ActionListener<Payload>)delegate);
                        return;
                    }
                    docGroupsCounter = 1;
                    sample = new ArrayList(this.maxCriteria);
                    continue;
                }
                ++docGroupsCounter;
            }
            log.trace("Final step... found [{}] new Samples", (Object)(this.samples.size() - initialSize));
            Page next = page.size == this.fetchSize ? page : this.stack.pop();
            log.trace("Final step... getting next page of the " + (next == page ? "current" : "previous") + " page");
            this.nextPage((ActionListener<Payload>)delegate, next);
        }));
    }

    private void updateMemoryUsage() {
        long newSamplesRamSize = RamUsageEstimator.sizeOfCollection(this.samples);
        this.addMemory(newSamplesRamSize - this.samplesRamBytesUsed, CB_COMPLETED_LABEL);
        this.samplesRamBytesUsed = newSamplesRamSize;
        long newStackRamSize = RamUsageEstimator.sizeOfCollection(this.stack);
        this.addMemory(newStackRamSize - this.stackRamBytesUsed, CB_INFLIGHT_LABEL);
        this.stackRamBytesUsed = newStackRamSize;
    }

    private void nextPage(ActionListener<Payload> listener, Page page) {
        page.request.nextAfter(page.afterKey);
        log.trace("Getting next page for page [{}] with afterkey [{}]", (Object)page, page.afterKey);
        this.queryForCompositeAggPage(listener, page.request);
    }

    private void payload(ActionListener<Payload> listener) {
        log.trace("Sending payload for [{}] samples", (Object)this.samples.size());
        if (this.samples.isEmpty()) {
            listener.onResponse((Object)new EmptyPayload(Payload.Type.SAMPLE, this.timeTook()));
            return;
        }
        this.client.fetchHits(this.hits(this.samples), (ActionListener<List<List<SearchHit>>>)ActionListeners.map(listener, listOfHits -> new SamplePayload(this.samples, (List<List<SearchHit>>)listOfHits, false, this.timeTook())));
    }

    Iterable<List<HitReference>> hits(List<Sample> samples) {
        return () -> {
            final Iterator delegate = samples.iterator();
            return new Iterator<List<HitReference>>(){

                @Override
                public boolean hasNext() {
                    return delegate.hasNext();
                }

                @Override
                public List<HitReference> next() {
                    return ((Sample)delegate.next()).hits();
                }
            };
        };
    }

    static List<List<SearchHit>> matchSamples(List<List<SearchHit>> hits, int hitsCount, int maxSamplesPerKey) {
        if (hits.size() < hitsCount) {
            return null;
        }
        ArrayList<List<SearchHit>> result = new ArrayList<List<SearchHit>>(maxSamplesPerKey);
        SampleIterator.match(0, hits, result, new ArrayList<SearchHit>(hitsCount), hitsCount, maxSamplesPerKey);
        return result;
    }

    private static void match(int currentCriterion, List<List<SearchHit>> hits, List<List<SearchHit>> result, List<SearchHit> partial, int hitsCount, int maxSamplesPerKey) {
        for (SearchHit o : hits.get(currentCriterion)) {
            if (partial.contains(o)) continue;
            partial.add(o);
            if (currentCriterion == hitsCount - 1) {
                result.add(new ArrayList<SearchHit>(partial));
                if (maxSamplesPerKey == result.size()) {
                    return;
                }
            } else {
                SampleIterator.match(currentCriterion + 1, hits, result, partial, hitsCount, maxSamplesPerKey);
                if (maxSamplesPerKey == result.size()) {
                    return;
                }
            }
            partial.remove(partial.size() - 1);
        }
    }

    private void addMemory(long bytes, String label) {
        this.circuitBreaker.addEstimateBytesAndMaybeBreak(bytes, label);
        this.totalRamBytesUsed += bytes;
    }

    private void clearCircuitBreaker() {
        this.circuitBreaker.addWithoutBreaking(-this.totalRamBytesUsed);
        this.stackRamBytesUsed = 0L;
        this.samplesRamBytesUsed = 0L;
        this.totalRamBytesUsed = 0L;
        this.totalPageSize = 0L;
        this.previousTotalPageSize = 0L;
    }

    private TimeValue timeTook() {
        return new TimeValue(System.currentTimeMillis() - this.startTime);
    }

    protected static class Page
    implements Accountable {
        final List<InternalComposite.InternalBucket> hits;
        final int size;
        final Map<String, Object> afterKey;
        final List<String> keys;
        final SampleQueryRequest request;
        long ramBytesUsed = 0L;
        private static final long SHALLOW_SIZE = RamUsageEstimator.shallowSizeOfInstance(Page.class);

        protected Page(int size) {
            this.hits = null;
            this.size = size;
            this.afterKey = null;
            this.keys = null;
            this.request = null;
        }

        protected Page(InternalComposite compositeAgg, SampleQueryRequest request) {
            this.hits = compositeAgg.getBuckets();
            this.size = compositeAgg.getBuckets().size();
            this.afterKey = compositeAgg.afterKey();
            this.keys = request.keys();
            this.request = request;
        }

        public long ramBytesUsed() {
            if (this.ramBytesUsed == 0L) {
                this.ramBytesUsed = SHALLOW_SIZE;
                this.ramBytesUsed += RamUsageEstimator.sizeOfCollection(this.hits);
                this.ramBytesUsed += RamUsageEstimator.sizeOfCollection(this.keys);
                this.ramBytesUsed += RamUsageEstimator.sizeOfMap(this.afterKey);
            }
            return this.ramBytesUsed;
        }

        public Collection<Accountable> getChildResources() {
            return super.getChildResources();
        }
    }
}

