/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.datastreams.lifecycle.rest;

import java.io.IOException;
import java.util.List;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.datastreams.lifecycle.PutDataStreamLifecycleAction;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.client.internal.node.NodeClient;
import org.elasticsearch.common.Strings;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestUtils;
import org.elasticsearch.rest.Scope;
import org.elasticsearch.rest.ServerlessScope;
import org.elasticsearch.rest.action.RestToXContentListener;
import org.elasticsearch.xcontent.XContentParser;

@ServerlessScope(value=Scope.PUBLIC)
public class RestPutDataStreamLifecycleAction
extends BaseRestHandler {
    public String getName() {
        return "put_data_lifecycles_action";
    }

    public List<RestHandler.Route> routes() {
        return List.of(new RestHandler.Route(RestRequest.Method.PUT, "/_data_stream/{name}/_lifecycle"));
    }

    protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        try (XContentParser parser = request.contentParser();){
            PutDataStreamLifecycleAction.Request putLifecycleRequest = PutDataStreamLifecycleAction.Request.parseRequest((XContentParser)parser);
            putLifecycleRequest.indices(Strings.splitStringByCommaToArray((String)request.param("name")));
            putLifecycleRequest.masterNodeTimeout(RestUtils.getMasterNodeTimeout((RestRequest)request));
            putLifecycleRequest.ackTimeout(RestUtils.getAckTimeout((RestRequest)request));
            putLifecycleRequest.indicesOptions(IndicesOptions.fromRequest((RestRequest)request, (IndicesOptions)putLifecycleRequest.indicesOptions()));
            BaseRestHandler.RestChannelConsumer restChannelConsumer = channel -> client.execute(PutDataStreamLifecycleAction.INSTANCE, (ActionRequest)putLifecycleRequest, (ActionListener)new RestToXContentListener(channel));
            return restChannelConsumer;
        }
    }
}

