/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.datastreams.lifecycle.action;

import java.util.List;
import java.util.concurrent.Executor;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.datastreams.DataStreamsActionUtil;
import org.elasticsearch.action.datastreams.lifecycle.PutDataStreamLifecycleAction;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.action.support.master.AcknowledgedTransportMasterNodeAction;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.metadata.MetadataDataStreamsService;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.indices.SystemIndices;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class TransportPutDataStreamLifecycleAction
extends AcknowledgedTransportMasterNodeAction<PutDataStreamLifecycleAction.Request> {
    private final MetadataDataStreamsService metadataDataStreamsService;
    private final SystemIndices systemIndices;

    @Inject
    public TransportPutDataStreamLifecycleAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, MetadataDataStreamsService metadataDataStreamsService, SystemIndices systemIndices) {
        super(PutDataStreamLifecycleAction.INSTANCE.name(), transportService, clusterService, threadPool, actionFilters, PutDataStreamLifecycleAction.Request::new, indexNameExpressionResolver, (Executor)EsExecutors.DIRECT_EXECUTOR_SERVICE);
        this.metadataDataStreamsService = metadataDataStreamsService;
        this.systemIndices = systemIndices;
    }

    protected void masterOperation(Task task, PutDataStreamLifecycleAction.Request request, ClusterState state, ActionListener<AcknowledgedResponse> listener) {
        List dataStreamNames = DataStreamsActionUtil.getDataStreamNames((IndexNameExpressionResolver)this.indexNameExpressionResolver, (ClusterState)state, (String[])request.getNames(), (IndicesOptions)request.indicesOptions());
        for (String name : dataStreamNames) {
            this.systemIndices.validateDataStreamAccess(name, this.threadPool.getThreadContext());
        }
        this.metadataDataStreamsService.setLifecycle(dataStreamNames, request.getLifecycle(), request.ackTimeout(), request.masterNodeTimeout(), listener);
    }

    protected ClusterBlockException checkBlock(PutDataStreamLifecycleAction.Request request, ClusterState state) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_WRITE);
    }
}

