/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.datastreams.lifecycle.action;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.Set;
import java.util.concurrent.Executor;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.master.TransportMasterNodeReadAction;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.DataStream;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.datastreams.lifecycle.DataStreamLifecycleService;
import org.elasticsearch.datastreams.lifecycle.action.GetDataStreamLifecycleStatsAction;
import org.elasticsearch.index.Index;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class TransportGetDataStreamLifecycleStatsAction
extends TransportMasterNodeReadAction<GetDataStreamLifecycleStatsAction.Request, GetDataStreamLifecycleStatsAction.Response> {
    private final DataStreamLifecycleService lifecycleService;

    @Inject
    public TransportGetDataStreamLifecycleStatsAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, DataStreamLifecycleService lifecycleService) {
        super("cluster:monitor/data_stream/lifecycle/stats", transportService, clusterService, threadPool, actionFilters, GetDataStreamLifecycleStatsAction.Request::new, indexNameExpressionResolver, GetDataStreamLifecycleStatsAction.Response::new, (Executor)EsExecutors.DIRECT_EXECUTOR_SERVICE);
        this.lifecycleService = lifecycleService;
    }

    protected void masterOperation(Task task, GetDataStreamLifecycleStatsAction.Request request, ClusterState state, ActionListener<GetDataStreamLifecycleStatsAction.Response> listener) throws Exception {
        listener.onResponse((Object)this.collectStats(state));
    }

    GetDataStreamLifecycleStatsAction.Response collectStats(ClusterState state) {
        Metadata metadata = state.metadata();
        Set<String> indicesInErrorStore = this.lifecycleService.getErrorStore().getAllIndices();
        ArrayList<GetDataStreamLifecycleStatsAction.Response.DataStreamStats> dataStreamStats = new ArrayList<GetDataStreamLifecycleStatsAction.Response.DataStreamStats>();
        for (DataStream dataStream : state.metadata().dataStreams().values()) {
            if (dataStream.getLifecycle() == null || !dataStream.getLifecycle().isEnabled()) continue;
            int total = 0;
            int inError = 0;
            for (Index index : dataStream.getIndices()) {
                if (!dataStream.isIndexManagedByDataStreamLifecycle(index, arg_0 -> ((Metadata)metadata).index(arg_0))) continue;
                ++total;
                if (!indicesInErrorStore.contains(index.getName())) continue;
                ++inError;
            }
            dataStreamStats.add(new GetDataStreamLifecycleStatsAction.Response.DataStreamStats(dataStream.getName(), total, inError));
        }
        return new GetDataStreamLifecycleStatsAction.Response(this.lifecycleService.getLastRunDuration(), this.lifecycleService.getTimeBetweenStarts(), dataStreamStats.isEmpty() ? dataStreamStats : dataStreamStats.stream().sorted(Comparator.comparing(GetDataStreamLifecycleStatsAction.Response.DataStreamStats::dataStreamName)).toList());
    }

    protected ClusterBlockException checkBlock(GetDataStreamLifecycleStatsAction.Request request, ClusterState state) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_READ);
    }
}

