/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.datastreams.lifecycle.action;

import java.io.IOException;
import java.util.Objects;
import java.util.concurrent.Executor;
import org.elasticsearch.ResourceNotFoundException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.master.MasterNodeReadRequest;
import org.elasticsearch.action.support.master.TransportMasterNodeReadAction;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.DataStreamGlobalRetention;
import org.elasticsearch.cluster.metadata.DataStreamGlobalRetentionResolver;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.features.FeatureService;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;

public class GetDataStreamGlobalRetentionAction {
    public static final ActionType<Response> INSTANCE = new ActionType("cluster:monitor/data_stream/global_retention/get");

    private GetDataStreamGlobalRetentionAction() {
    }

    public static class TransportGetDataStreamGlobalSettingsAction
    extends TransportMasterNodeReadAction<Request, Response> {
        private final FeatureService featureService;
        private final DataStreamGlobalRetentionResolver globalRetentionResolver;

        @Inject
        public TransportGetDataStreamGlobalSettingsAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, FeatureService featureService, DataStreamGlobalRetentionResolver globalRetentionResolver) {
            super(INSTANCE.name(), transportService, clusterService, threadPool, actionFilters, Request::new, indexNameExpressionResolver, Response::new, (Executor)threadPool.executor("management"));
            this.featureService = featureService;
            this.globalRetentionResolver = globalRetentionResolver;
        }

        protected void masterOperation(Task task, Request request, ClusterState state, ActionListener<Response> listener) throws Exception {
            if (!this.featureService.clusterHasFeature(state, DataStreamGlobalRetention.GLOBAL_RETENTION)) {
                listener.onFailure((Exception)new ResourceNotFoundException("Data stream global retention feature not found, please ensure all nodes have the feature " + DataStreamGlobalRetention.GLOBAL_RETENTION.id(), new Object[0]));
                return;
            }
            DataStreamGlobalRetention globalRetention = this.globalRetentionResolver.resolve(state);
            listener.onResponse((Object)new Response(globalRetention == null ? DataStreamGlobalRetention.EMPTY : globalRetention));
        }

        protected ClusterBlockException checkBlock(Request request, ClusterState state) {
            return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_READ);
        }
    }

    public static class Response
    extends ActionResponse
    implements ToXContentObject {
        private final DataStreamGlobalRetention globalRetention;

        public Response(DataStreamGlobalRetention globalRetention) {
            this.globalRetention = globalRetention;
        }

        public Response(StreamInput in) throws IOException {
            super(in);
            this.globalRetention = DataStreamGlobalRetention.read((StreamInput)in);
        }

        public void writeTo(StreamOutput out) throws IOException {
            this.globalRetention.writeTo(out);
        }

        public String toString() {
            return "Response{globalRetention=" + this.globalRetention + "}";
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            this.globalRetention.toXContentFragment(builder, params);
            builder.endObject();
            return builder;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            Response that = (Response)((Object)o);
            return Objects.equals(this.globalRetention, that.globalRetention);
        }

        public int hashCode() {
            return Objects.hash(this.globalRetention);
        }
    }

    public static final class Request
    extends MasterNodeReadRequest<Request> {
        public Request(StreamInput in) throws IOException {
            super(in);
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
        }

        public ActionRequestValidationException validate() {
            return null;
        }

        public boolean equals(Object obj) {
            return super.equals(obj);
        }

        public int hashCode() {
            return super.hashCode();
        }
    }
}

