/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.datastreams.lifecycle.action;

import java.io.IOException;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Executor;
import org.elasticsearch.ResourceNotFoundException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.master.MasterNodeRequest;
import org.elasticsearch.action.support.master.TransportMasterNodeAction;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.DataStreamGlobalRetention;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.datastreams.lifecycle.UpdateDataStreamGlobalRetentionService;
import org.elasticsearch.datastreams.lifecycle.action.UpdateDataStreamGlobalRetentionResponse;
import org.elasticsearch.features.FeatureService;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class DeleteDataStreamGlobalRetentionAction {
    public static final ActionType<UpdateDataStreamGlobalRetentionResponse> INSTANCE = new ActionType("cluster:admin/data_stream/global_retention/delete");

    private DeleteDataStreamGlobalRetentionAction() {
    }

    public static class TransportDeleteDataStreamGlobalRetentionAction
    extends TransportMasterNodeAction<Request, UpdateDataStreamGlobalRetentionResponse> {
        private final UpdateDataStreamGlobalRetentionService globalRetentionService;
        private final FeatureService featureService;

        @Inject
        public TransportDeleteDataStreamGlobalRetentionAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, UpdateDataStreamGlobalRetentionService globalRetentionService, FeatureService featureService) {
            super(INSTANCE.name(), transportService, clusterService, threadPool, actionFilters, Request::new, indexNameExpressionResolver, UpdateDataStreamGlobalRetentionResponse::new, (Executor)threadPool.executor("management"));
            this.globalRetentionService = globalRetentionService;
            this.featureService = featureService;
        }

        protected void masterOperation(Task task, Request request, ClusterState state, ActionListener<UpdateDataStreamGlobalRetentionResponse> listener) throws Exception {
            if (!this.featureService.clusterHasFeature(state, DataStreamGlobalRetention.GLOBAL_RETENTION)) {
                listener.onFailure((Exception)new ResourceNotFoundException("Data stream global retention feature not found, please ensure all nodes have the feature " + DataStreamGlobalRetention.GLOBAL_RETENTION.id(), new Object[0]));
                return;
            }
            List<UpdateDataStreamGlobalRetentionResponse.AffectedDataStream> affectedDataStreams = this.globalRetentionService.determineAffectedDataStreams(null, state);
            if (request.dryRun()) {
                listener.onResponse((Object)new UpdateDataStreamGlobalRetentionResponse(false, true, affectedDataStreams));
            } else {
                this.globalRetentionService.removeGlobalRetention(request, affectedDataStreams, listener);
            }
        }

        protected ClusterBlockException checkBlock(Request request, ClusterState state) {
            return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_WRITE);
        }
    }

    public static final class Request
    extends MasterNodeRequest<Request> {
        private boolean dryRun = false;

        public Request(StreamInput in) throws IOException {
            super(in);
            this.dryRun = in.readBoolean();
        }

        public ActionRequestValidationException validate() {
            return null;
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeBoolean(this.dryRun);
        }

        public Request(TimeValue masterNodeTimeout) {
            super(masterNodeTimeout);
        }

        public boolean dryRun() {
            return this.dryRun;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            Request request = (Request)((Object)o);
            return this.dryRun == request.dryRun;
        }

        public int hashCode() {
            return Objects.hash(this.dryRun);
        }

        public void dryRun(boolean dryRun) {
            this.dryRun = dryRun;
        }
    }
}

