/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.datastreams.lifecycle;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateAckListener;
import org.elasticsearch.cluster.ClusterStateTaskExecutor;
import org.elasticsearch.cluster.ClusterStateTaskListener;
import org.elasticsearch.cluster.SimpleBatchedAckListenerTaskExecutor;
import org.elasticsearch.cluster.metadata.DataStream;
import org.elasticsearch.cluster.metadata.DataStreamGlobalRetention;
import org.elasticsearch.cluster.metadata.DataStreamGlobalRetentionResolver;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.cluster.service.MasterServiceTaskQueue;
import org.elasticsearch.common.Priority;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.core.Tuple;
import org.elasticsearch.datastreams.lifecycle.action.DeleteDataStreamGlobalRetentionAction;
import org.elasticsearch.datastreams.lifecycle.action.PutDataStreamGlobalRetentionAction;
import org.elasticsearch.datastreams.lifecycle.action.UpdateDataStreamGlobalRetentionResponse;

public class UpdateDataStreamGlobalRetentionService {
    private static final Logger logger = LogManager.getLogger(UpdateDataStreamGlobalRetentionService.class);
    private final DataStreamGlobalRetentionResolver globalRetentionResolver;
    private final MasterServiceTaskQueue<UpsertGlobalDataStreamMetadataTask> taskQueue;

    public UpdateDataStreamGlobalRetentionService(ClusterService clusterService, DataStreamGlobalRetentionResolver globalRetentionResolver) {
        this.globalRetentionResolver = globalRetentionResolver;
        SimpleBatchedAckListenerTaskExecutor<UpsertGlobalDataStreamMetadataTask> executor = new SimpleBatchedAckListenerTaskExecutor<UpsertGlobalDataStreamMetadataTask>(){

            public Tuple<ClusterState, ClusterStateAckListener> executeTask(UpsertGlobalDataStreamMetadataTask task, ClusterState clusterState) {
                return new Tuple((Object)UpdateDataStreamGlobalRetentionService.this.updateGlobalRetention(clusterState, task.globalRetention()), (Object)task);
            }
        };
        this.taskQueue = clusterService.createTaskQueue("data-stream-global-retention", Priority.HIGH, (ClusterStateTaskExecutor)executor);
    }

    public void updateGlobalRetention(PutDataStreamGlobalRetentionAction.Request request, List<UpdateDataStreamGlobalRetentionResponse.AffectedDataStream> affectedDataStreams, ActionListener<UpdateDataStreamGlobalRetentionResponse> listener) {
        this.taskQueue.submitTask("update-data-stream-global-retention", (ClusterStateTaskListener)new UpsertGlobalDataStreamMetadataTask(request.getGlobalRetention(), affectedDataStreams, listener, request.masterNodeTimeout()), request.masterNodeTimeout());
    }

    public void removeGlobalRetention(DeleteDataStreamGlobalRetentionAction.Request request, List<UpdateDataStreamGlobalRetentionResponse.AffectedDataStream> affectedDataStreams, ActionListener<UpdateDataStreamGlobalRetentionResponse> listener) {
        this.taskQueue.submitTask("remove-data-stream-global-retention", (ClusterStateTaskListener)new UpsertGlobalDataStreamMetadataTask(null, affectedDataStreams, listener, request.masterNodeTimeout()), request.masterNodeTimeout());
    }

    public List<UpdateDataStreamGlobalRetentionResponse.AffectedDataStream> determineAffectedDataStreams(@Nullable DataStreamGlobalRetention newGlobalRetention, ClusterState clusterState) {
        DataStreamGlobalRetention previousGlobalRetention = this.globalRetentionResolver.resolve(clusterState);
        if (Objects.equals(newGlobalRetention, previousGlobalRetention)) {
            return List.of();
        }
        ArrayList<UpdateDataStreamGlobalRetentionResponse.AffectedDataStream> affectedDataStreams = new ArrayList<UpdateDataStreamGlobalRetentionResponse.AffectedDataStream>();
        for (DataStream dataStream : clusterState.metadata().dataStreams().values()) {
            TimeValue newEffectiveRetention;
            TimeValue previousEffectiveRetention;
            if (dataStream.getLifecycle() == null || Objects.equals(previousEffectiveRetention = dataStream.getLifecycle().getEffectiveDataRetention(dataStream.isSystem() ? null : previousGlobalRetention), newEffectiveRetention = dataStream.getLifecycle().getEffectiveDataRetention(dataStream.isSystem() ? null : newGlobalRetention))) continue;
            affectedDataStreams.add(new UpdateDataStreamGlobalRetentionResponse.AffectedDataStream(dataStream.getName(), newEffectiveRetention, previousEffectiveRetention));
        }
        affectedDataStreams.sort(Comparator.comparing(UpdateDataStreamGlobalRetentionResponse.AffectedDataStream::dataStreamName));
        return affectedDataStreams;
    }

    ClusterState updateGlobalRetention(ClusterState clusterState, @Nullable DataStreamGlobalRetention retentionFromRequest) {
        DataStreamGlobalRetention newRetention;
        DataStreamGlobalRetention initialRetentionFromClusterState = DataStreamGlobalRetention.getFromClusterState((ClusterState)clusterState);
        DataStreamGlobalRetention dataStreamGlobalRetention = newRetention = DataStreamGlobalRetention.EMPTY.equals((Object)retentionFromRequest) ? null : retentionFromRequest;
        if (Objects.equals(newRetention, initialRetentionFromClusterState)) {
            return clusterState;
        }
        if (newRetention == null) {
            return clusterState.copyAndUpdate(b -> b.removeCustom("data-stream-global-retention"));
        }
        return clusterState.copyAndUpdate(b -> b.putCustom("data-stream-global-retention", (ClusterState.Custom)newRetention));
    }

    record UpsertGlobalDataStreamMetadataTask(@Nullable DataStreamGlobalRetention globalRetention, List<UpdateDataStreamGlobalRetentionResponse.AffectedDataStream> affectedDataStreams, ActionListener<UpdateDataStreamGlobalRetentionResponse> listener, TimeValue ackTimeout) implements ClusterStateTaskListener,
    ClusterStateAckListener
    {
        public void onFailure(Exception e) {
            this.listener.onFailure(e);
        }

        public boolean mustAck(DiscoveryNode discoveryNode) {
            return true;
        }

        public void onAllNodesAcked() {
            this.listener.onResponse((Object)new UpdateDataStreamGlobalRetentionResponse(true, this.affectedDataStreams));
        }

        public void onAckFailure(Exception e) {
            logger.debug("Failed to update global retention [{}] with error [{}]", (Object)this.globalRetention, (Object)e.getMessage());
            this.listener.onResponse((Object)UpdateDataStreamGlobalRetentionResponse.FAILED);
        }

        public void onAckTimeout() {
            logger.debug("Failed to update global retention [{}] because timeout was reached", (Object)this.globalRetention);
            this.listener.onResponse((Object)UpdateDataStreamGlobalRetentionResponse.FAILED);
        }
    }
}

