/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.transform.transforms;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.action.search.SearchPhaseExecutionException;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.common.breaker.CircuitBreakingException;
import org.elasticsearch.core.Strings;
import org.elasticsearch.script.ScriptException;
import org.elasticsearch.xpack.core.common.notifications.Level;
import org.elasticsearch.xpack.core.transform.TransformMessages;
import org.elasticsearch.xpack.core.transform.transforms.SettingsConfig;
import org.elasticsearch.xpack.core.transform.transforms.TransformEffectiveSettings;
import org.elasticsearch.xpack.core.transform.utils.ExceptionsHelper;
import org.elasticsearch.xpack.transform.notifications.TransformAuditor;
import org.elasticsearch.xpack.transform.transforms.BulkIndexingException;
import org.elasticsearch.xpack.transform.transforms.TransformContext;
import org.elasticsearch.xpack.transform.utils.ExceptionRootCauseFinder;

class TransformFailureHandler {
    private static final Logger logger = LogManager.getLogger(TransformFailureHandler.class);
    public static final int LOG_FAILURE_EVERY = 10;
    private final TransformAuditor auditor;
    private final String transformId;
    private final TransformContext context;

    TransformFailureHandler(TransformAuditor auditor, TransformContext context, String transformId) {
        this.auditor = auditor;
        this.transformId = transformId;
        this.context = context;
    }

    void handleIndexerFailure(Exception exception, SettingsConfig settingsConfig) {
        logger.atDebug().withThrowable((Throwable)exception).log("[{}] transform encountered an exception", (Object)this.transformId);
        Throwable unwrappedException = ExceptionsHelper.findSearchExceptionRootCause((Throwable)exception);
        boolean unattended = TransformEffectiveSettings.isUnattended((SettingsConfig)settingsConfig);
        int numFailureRetries = TransformEffectiveSettings.getNumFailureRetries((SettingsConfig)settingsConfig, (int)this.context.getNumFailureRetries());
        if (unwrappedException instanceof CircuitBreakingException) {
            CircuitBreakingException e = (CircuitBreakingException)unwrappedException;
            this.handleCircuitBreakingException(e, unattended);
        } else if (unwrappedException instanceof ScriptException) {
            ScriptException e = (ScriptException)unwrappedException;
            this.handleScriptException(e, unattended);
        } else if (unwrappedException instanceof BulkIndexingException) {
            BulkIndexingException e = (BulkIndexingException)((Object)unwrappedException);
            this.handleBulkIndexingException(e, unattended, numFailureRetries);
        } else if (unwrappedException instanceof ClusterBlockException) {
            ClusterBlockException e = (ClusterBlockException)unwrappedException;
            this.retry((Throwable)e, e.getDetailedMessage(), unattended, numFailureRetries);
        } else if (unwrappedException instanceof SearchPhaseExecutionException) {
            SearchPhaseExecutionException e;
            this.retry((Throwable)e, (e = (SearchPhaseExecutionException)unwrappedException).getCause() != null ? e.getCause().getMessage() : null, unattended, numFailureRetries);
        } else if (unwrappedException instanceof ElasticsearchException) {
            ElasticsearchException e = (ElasticsearchException)unwrappedException;
            this.handleElasticsearchException(e, unattended, numFailureRetries);
        } else if (unwrappedException instanceof IllegalArgumentException) {
            IllegalArgumentException e = (IllegalArgumentException)unwrappedException;
            this.handleIllegalArgumentException(e, unattended);
        } else {
            this.retry(unwrappedException, ExceptionRootCauseFinder.getDetailedMessage(unwrappedException), unattended, numFailureRetries);
        }
    }

    boolean handleStatePersistenceFailure(Exception e, SettingsConfig settingsConfig) {
        int numFailureRetries = TransformEffectiveSettings.getNumFailureRetries((SettingsConfig)settingsConfig, (int)this.context.getNumFailureRetries());
        int failureCount = this.context.incrementAndGetStatePersistenceFailureCount(e);
        if (numFailureRetries != -1 && failureCount > numFailureRetries) {
            this.fail(e, "task encountered more than " + numFailureRetries + " failures updating internal state; latest failure: " + e.getMessage());
            return false;
        }
        return true;
    }

    private void handleCircuitBreakingException(CircuitBreakingException circuitBreakingException, boolean unattended) {
        int pageSize = this.context.getPageSize();
        double reducingFactor = Math.min((double)circuitBreakingException.getByteLimit() / (double)circuitBreakingException.getBytesWanted(), 1.0 - Math.log10(pageSize) * 0.1);
        int newPageSize = (int)Math.round(reducingFactor * (double)pageSize);
        if (newPageSize < 10) {
            String message = TransformMessages.getMessage((String)"Insufficient memory for search after repeated page size reductions to [{0}], unable to continue pivot, please simplify job or increase heap size on data nodes.", (Object[])new Object[]{pageSize});
            if (unattended) {
                this.retry((Throwable)circuitBreakingException, message, true, -1);
            } else {
                this.fail((Throwable)circuitBreakingException, message);
            }
        } else {
            String message = TransformMessages.getMessage((String)"Insufficient memory for search, reducing number of buckets per search from [{0}] to [{1}]", (Object[])new Object[]{pageSize, newPageSize});
            this.auditor.info(this.transformId, message);
            logger.info("[{}] {}", (Object)this.transformId, (Object)message);
            this.context.setPageSize(newPageSize);
        }
    }

    private void handleScriptException(ScriptException scriptException, boolean unattended) {
        String message = TransformMessages.getMessage((String)"Failed to execute script with error: [{0}], stack trace: {1}", (Object[])new Object[]{scriptException.getDetailedMessage(), scriptException.getScriptStack()});
        if (unattended) {
            this.retry((Throwable)scriptException, message, true, -1);
        } else {
            this.fail((Throwable)scriptException, message);
        }
    }

    private void handleBulkIndexingException(BulkIndexingException bulkIndexingException, boolean unattended, int numFailureRetries) {
        if (!unattended && bulkIndexingException.isIrrecoverable()) {
            String message = TransformMessages.getMessage((String)"Failed to index documents into destination index due to permanent error: [{0}]", (Object[])new Object[]{bulkIndexingException.getDetailedMessage()});
            this.fail((Throwable)((Object)bulkIndexingException), message);
        } else {
            this.retry((Throwable)((Object)bulkIndexingException), bulkIndexingException.getDetailedMessage(), unattended, numFailureRetries);
        }
    }

    private void handleElasticsearchException(ElasticsearchException elasticsearchException, boolean unattended, int numFailureRetries) {
        if (!unattended && ExceptionRootCauseFinder.isExceptionIrrecoverable(elasticsearchException)) {
            String message = "task encountered irrecoverable failure: " + elasticsearchException.getDetailedMessage();
            this.fail(elasticsearchException, message);
        } else {
            this.retry(elasticsearchException, elasticsearchException.getDetailedMessage(), unattended, numFailureRetries);
        }
    }

    private void handleIllegalArgumentException(IllegalArgumentException illegalArgumentException, boolean unattended) {
        if (unattended) {
            this.retry(illegalArgumentException, illegalArgumentException.getMessage(), true, -1);
        } else {
            String message = "task encountered irrecoverable failure: " + illegalArgumentException.getMessage();
            this.fail(illegalArgumentException, message);
        }
    }

    private void retry(Throwable unwrappedException, String message, boolean unattended, int numFailureRetries) {
        boolean repeatedFailure = this.context.getLastFailure() != null && unwrappedException.getClass().equals(this.context.getLastFailure().getClass());
        int failureCount = this.context.incrementAndGetFailureCount(unwrappedException);
        if (!unattended && numFailureRetries != -1 && failureCount > numFailureRetries) {
            this.fail(unwrappedException, "task encountered more than " + numFailureRetries + " failures; latest failure: " + message);
            return;
        }
        if (!repeatedFailure || failureCount % 10 == 0 || failureCount == numFailureRetries) {
            String retryMessage = Strings.format((String)"Transform encountered an exception: [%s]; Will automatically retry [%d/%d]", (Object[])new Object[]{message, failureCount, numFailureRetries});
            logger.atLevel(unattended ? org.apache.logging.log4j.Level.INFO : org.apache.logging.log4j.Level.WARN).withThrowable(unwrappedException).log("[{}] {}", (Object)this.transformId, (Object)retryMessage);
            this.auditor.audit(unattended ? Level.INFO : Level.WARNING, this.transformId, retryMessage);
        }
    }

    private void fail(Throwable exception, String failureMessage) {
        this.context.markAsFailed(exception, failureMessage);
    }
}

