/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.transform.action;

import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import org.elasticsearch.action.FailedNodeException;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.nodes.TransportNodesAction;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.transform.action.GetTransformNodeStatsAction;
import org.elasticsearch.xpack.core.transform.transforms.TransformSchedulerStats;
import org.elasticsearch.xpack.transform.TransformServices;
import org.elasticsearch.xpack.transform.transforms.scheduling.TransformScheduler;

public class TransportGetTransformNodeStatsAction
extends TransportNodesAction<GetTransformNodeStatsAction.NodesStatsRequest, GetTransformNodeStatsAction.NodesStatsResponse, GetTransformNodeStatsAction.NodeStatsRequest, GetTransformNodeStatsAction.NodeStatsResponse> {
    private final TransportService transportService;
    private final TransformScheduler scheduler;

    @Inject
    public TransportGetTransformNodeStatsAction(ThreadPool threadPool, ClusterService clusterService, TransportService transportService, ActionFilters actionFilters, TransformServices transformServices) {
        super("cluster:admin/transform/node_stats", clusterService, transportService, actionFilters, GetTransformNodeStatsAction.NodeStatsRequest::new, (Executor)threadPool.executor("management"));
        this.transportService = transportService;
        this.scheduler = transformServices.scheduler();
    }

    protected GetTransformNodeStatsAction.NodesStatsResponse newResponse(GetTransformNodeStatsAction.NodesStatsRequest request, List<GetTransformNodeStatsAction.NodeStatsResponse> nodes, List<FailedNodeException> failures) {
        return new GetTransformNodeStatsAction.NodesStatsResponse(this.clusterService.getClusterName(), nodes, failures);
    }

    protected GetTransformNodeStatsAction.NodeStatsRequest newNodeRequest(GetTransformNodeStatsAction.NodesStatsRequest request) {
        return new GetTransformNodeStatsAction.NodeStatsRequest();
    }

    protected GetTransformNodeStatsAction.NodeStatsResponse newNodeResponse(StreamInput in, DiscoveryNode node) throws IOException {
        return new GetTransformNodeStatsAction.NodeStatsResponse(in);
    }

    protected GetTransformNodeStatsAction.NodeStatsResponse nodeOperation(GetTransformNodeStatsAction.NodeStatsRequest request, Task task) {
        DiscoveryNode localNode = this.transportService.getLocalNode();
        TransformSchedulerStats schedulerStats = this.scheduler.getStats();
        return new GetTransformNodeStatsAction.NodeStatsResponse(localNode, schedulerStats);
    }
}

