/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.services.settings;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.inference.ServiceSettings;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;

public abstract class InternalServiceSettings
implements ServiceSettings {
    public static final String NUM_ALLOCATIONS = "num_allocations";
    public static final String NUM_THREADS = "num_threads";
    public static final String MODEL_ID = "model_id";
    private final int numAllocations;
    private final int numThreads;
    private final String modelId;

    public InternalServiceSettings(int numAllocations, int numThreads, String modelId) {
        this.numAllocations = numAllocations;
        this.numThreads = numThreads;
        this.modelId = modelId;
    }

    public int getNumAllocations() {
        return this.numAllocations;
    }

    public int getNumThreads() {
        return this.numThreads;
    }

    public String getModelId() {
        return this.modelId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InternalServiceSettings that = (InternalServiceSettings)o;
        return this.numAllocations == that.numAllocations && this.numThreads == that.numThreads && Objects.equals(this.modelId, that.modelId);
    }

    public int hashCode() {
        return Objects.hash(this.numAllocations, this.numThreads, this.modelId);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        this.addXContentFragment(builder, params);
        builder.endObject();
        return builder;
    }

    public void addXContentFragment(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.field(NUM_ALLOCATIONS, this.getNumAllocations());
        builder.field(NUM_THREADS, this.getNumThreads());
        builder.field(MODEL_ID, this.getModelId());
    }

    public ToXContentObject getFilteredXContentObject() {
        return this;
    }

    public boolean isFragment() {
        return super.isFragment();
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeVInt(this.getNumAllocations());
        out.writeVInt(this.getNumThreads());
        out.writeString(this.getModelId());
    }

    public static abstract class Builder {
        private int numAllocations;
        private int numThreads;
        private String modelId;

        public abstract InternalServiceSettings build();

        public void setNumAllocations(int numAllocations) {
            this.numAllocations = numAllocations;
        }

        public void setNumThreads(int numThreads) {
            this.numThreads = numThreads;
        }

        public void setModelId(String modelId) {
            this.modelId = modelId;
        }

        public String getModelId() {
            return this.modelId;
        }

        public int getNumAllocations() {
            return this.numAllocations;
        }

        public int getNumThreads() {
            return this.numThreads;
        }
    }
}

