/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.services.openai.embeddings;

import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.common.ValidationException;
import org.elasticsearch.common.VersionId;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.inference.TaskSettings;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.inference.services.ConfigurationParseContext;
import org.elasticsearch.xpack.inference.services.ServiceUtils;
import org.elasticsearch.xpack.inference.services.openai.embeddings.OpenAiEmbeddingsRequestTaskSettings;

public class OpenAiEmbeddingsTaskSettings
implements TaskSettings {
    public static final String NAME = "openai_embeddings_task_settings";
    private final String user;

    public static OpenAiEmbeddingsTaskSettings fromMap(Map<String, Object> map, ConfigurationParseContext context) {
        ValidationException validationException = new ValidationException();
        String user = ServiceUtils.extractOptionalString(map, "user", "task_settings", validationException);
        if (!validationException.validationErrors().isEmpty()) {
            throw validationException;
        }
        return new OpenAiEmbeddingsTaskSettings(user);
    }

    public static OpenAiEmbeddingsTaskSettings of(OpenAiEmbeddingsTaskSettings originalSettings, OpenAiEmbeddingsRequestTaskSettings requestSettings) {
        String userToUse = requestSettings.user() == null ? originalSettings.user : requestSettings.user();
        return new OpenAiEmbeddingsTaskSettings(userToUse);
    }

    public OpenAiEmbeddingsTaskSettings(@Nullable String user) {
        this.user = user;
    }

    public OpenAiEmbeddingsTaskSettings(StreamInput in) throws IOException {
        if (in.getTransportVersion().onOrAfter((VersionId)TransportVersions.V_8_13_0)) {
            this.user = in.readOptionalString();
        } else {
            String discard = in.readString();
            this.user = in.readOptionalString();
        }
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        if (this.user != null) {
            builder.field("user", this.user);
        }
        builder.endObject();
        return builder;
    }

    public String user() {
        return this.user;
    }

    public String getWriteableName() {
        return NAME;
    }

    public TransportVersion getMinimalSupportedVersion() {
        return TransportVersions.V_8_12_0;
    }

    public void writeTo(StreamOutput out) throws IOException {
        if (out.getTransportVersion().onOrAfter((VersionId)TransportVersions.V_8_13_0)) {
            out.writeOptionalString(this.user);
        } else {
            out.writeString("m");
            out.writeOptionalString(this.user);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OpenAiEmbeddingsTaskSettings that = (OpenAiEmbeddingsTaskSettings)o;
        return Objects.equals(this.user, that.user);
    }

    public int hashCode() {
        return Objects.hash(this.user);
    }
}

