/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.services.huggingface.embeddings;

import java.util.Map;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.inference.ModelConfigurations;
import org.elasticsearch.inference.ModelSecrets;
import org.elasticsearch.inference.SecretSettings;
import org.elasticsearch.inference.ServiceSettings;
import org.elasticsearch.inference.TaskType;
import org.elasticsearch.xpack.inference.external.action.ExecutableAction;
import org.elasticsearch.xpack.inference.external.action.huggingface.HuggingFaceActionVisitor;
import org.elasticsearch.xpack.inference.services.ConfigurationParseContext;
import org.elasticsearch.xpack.inference.services.huggingface.HuggingFaceModel;
import org.elasticsearch.xpack.inference.services.huggingface.HuggingFaceServiceSettings;
import org.elasticsearch.xpack.inference.services.settings.DefaultSecretSettings;

public class HuggingFaceEmbeddingsModel
extends HuggingFaceModel {
    public HuggingFaceEmbeddingsModel(String inferenceEntityId, TaskType taskType, String service, Map<String, Object> serviceSettings, @Nullable Map<String, Object> secrets, ConfigurationParseContext context) {
        this(inferenceEntityId, taskType, service, HuggingFaceServiceSettings.fromMap(serviceSettings, context), DefaultSecretSettings.fromMap(secrets));
    }

    HuggingFaceEmbeddingsModel(String inferenceEntityId, TaskType taskType, String service, HuggingFaceServiceSettings serviceSettings, @Nullable DefaultSecretSettings secrets) {
        super(new ModelConfigurations(inferenceEntityId, taskType, service, (ServiceSettings)serviceSettings), new ModelSecrets((SecretSettings)secrets), serviceSettings, secrets);
    }

    public HuggingFaceEmbeddingsModel(HuggingFaceEmbeddingsModel model, HuggingFaceServiceSettings serviceSettings) {
        this(model.getInferenceEntityId(), model.getTaskType(), model.getConfigurations().getService(), serviceSettings, model.getSecretSettings());
    }

    public HuggingFaceServiceSettings getServiceSettings() {
        return (HuggingFaceServiceSettings)super.getServiceSettings();
    }

    public DefaultSecretSettings getSecretSettings() {
        return (DefaultSecretSettings)super.getSecretSettings();
    }

    @Override
    public Integer getTokenLimit() {
        return this.getServiceSettings().maxInputTokens();
    }

    @Override
    public ExecutableAction accept(HuggingFaceActionVisitor creator) {
        return creator.create(this);
    }
}

