/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.services.huggingface.elser;

import java.io.IOException;
import java.net.URI;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.common.ValidationException;
import org.elasticsearch.common.VersionId;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.inference.ServiceSettings;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.inference.services.ConfigurationParseContext;
import org.elasticsearch.xpack.inference.services.ServiceUtils;
import org.elasticsearch.xpack.inference.services.huggingface.HuggingFaceRateLimitServiceSettings;
import org.elasticsearch.xpack.inference.services.huggingface.HuggingFaceServiceSettings;
import org.elasticsearch.xpack.inference.services.settings.FilteredXContentObject;
import org.elasticsearch.xpack.inference.services.settings.RateLimitSettings;

public class HuggingFaceElserServiceSettings
extends FilteredXContentObject
implements ServiceSettings,
HuggingFaceRateLimitServiceSettings {
    public static final String NAME = "hugging_face_elser_service_settings";
    static final String URL = "url";
    private static final int ELSER_TOKEN_LIMIT = 512;
    private static final RateLimitSettings DEFAULT_RATE_LIMIT_SETTINGS = new RateLimitSettings(3000L);
    private final URI uri;
    private final RateLimitSettings rateLimitSettings;

    public static HuggingFaceElserServiceSettings fromMap(Map<String, Object> map, ConfigurationParseContext context) {
        ValidationException validationException = new ValidationException();
        URI uri = HuggingFaceServiceSettings.extractUri(map, URL, validationException);
        RateLimitSettings rateLimitSettings = RateLimitSettings.of(map, DEFAULT_RATE_LIMIT_SETTINGS, validationException, "hugging_face", context);
        if (!validationException.validationErrors().isEmpty()) {
            throw validationException;
        }
        return new HuggingFaceElserServiceSettings(uri, rateLimitSettings);
    }

    public HuggingFaceElserServiceSettings(String url) {
        this.uri = ServiceUtils.createUri(url);
        this.rateLimitSettings = DEFAULT_RATE_LIMIT_SETTINGS;
    }

    HuggingFaceElserServiceSettings(URI uri, @Nullable RateLimitSettings rateLimitSettings) {
        this.uri = Objects.requireNonNull(uri);
        this.rateLimitSettings = Objects.requireNonNullElse(rateLimitSettings, DEFAULT_RATE_LIMIT_SETTINGS);
    }

    public HuggingFaceElserServiceSettings(StreamInput in) throws IOException {
        this.uri = ServiceUtils.createUri(in.readString());
        this.rateLimitSettings = in.getTransportVersion().onOrAfter((VersionId)TransportVersions.ML_INFERENCE_RATE_LIMIT_SETTINGS_ADDED) ? new RateLimitSettings(in) : DEFAULT_RATE_LIMIT_SETTINGS;
    }

    @Override
    public RateLimitSettings rateLimitSettings() {
        return this.rateLimitSettings;
    }

    @Override
    public URI uri() {
        return this.uri;
    }

    public int maxInputTokens() {
        return 512;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        this.toXContentFragmentOfExposedFields(builder, params);
        builder.endObject();
        return builder;
    }

    @Override
    protected XContentBuilder toXContentFragmentOfExposedFields(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.field(URL, this.uri.toString());
        builder.field("max_input_tokens", 512);
        this.rateLimitSettings.toXContent(builder, params);
        return builder;
    }

    public String getWriteableName() {
        return NAME;
    }

    public TransportVersion getMinimalSupportedVersion() {
        return TransportVersions.V_8_12_0;
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.uri.toString());
        if (out.getTransportVersion().onOrAfter((VersionId)TransportVersions.ML_INFERENCE_RATE_LIMIT_SETTINGS_ADDED)) {
            this.rateLimitSettings.writeTo(out);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HuggingFaceElserServiceSettings that = (HuggingFaceElserServiceSettings)o;
        return Objects.equals(this.uri, that.uri) && Objects.equals(this.rateLimitSettings, that.rateLimitSettings);
    }

    public int hashCode() {
        return Objects.hash(this.uri, this.rateLimitSettings);
    }
}

