/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.services.huggingface;

import java.util.List;
import java.util.Map;
import java.util.Set;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.inference.InferenceServiceResults;
import org.elasticsearch.inference.InputType;
import org.elasticsearch.inference.Model;
import org.elasticsearch.inference.TaskType;
import org.elasticsearch.xpack.inference.external.action.ExecutableAction;
import org.elasticsearch.xpack.inference.external.action.huggingface.HuggingFaceActionCreator;
import org.elasticsearch.xpack.inference.external.http.sender.DocumentsOnlyInput;
import org.elasticsearch.xpack.inference.external.http.sender.HttpRequestSender;
import org.elasticsearch.xpack.inference.services.ConfigurationParseContext;
import org.elasticsearch.xpack.inference.services.SenderService;
import org.elasticsearch.xpack.inference.services.ServiceComponents;
import org.elasticsearch.xpack.inference.services.ServiceUtils;
import org.elasticsearch.xpack.inference.services.huggingface.HuggingFaceModel;

public abstract class HuggingFaceBaseService
extends SenderService {
    static final int EMBEDDING_MAX_BATCH_SIZE = 20;

    public HuggingFaceBaseService(HttpRequestSender.Factory factory, ServiceComponents serviceComponents) {
        super(factory, serviceComponents);
    }

    public void parseRequestConfig(String inferenceEntityId, TaskType taskType, Map<String, Object> config, Set<String> platformArchitectures, ActionListener<Model> parsedModelListener) {
        try {
            Map<String, Object> serviceSettingsMap = ServiceUtils.removeFromMapOrThrowIfNull(config, "service_settings");
            HuggingFaceModel model = this.createModel(inferenceEntityId, taskType, serviceSettingsMap, serviceSettingsMap, TaskType.unsupportedTaskTypeErrorMsg((TaskType)taskType, (String)this.name()), ConfigurationParseContext.REQUEST);
            ServiceUtils.throwIfNotEmptyMap(config, this.name());
            ServiceUtils.throwIfNotEmptyMap(serviceSettingsMap, this.name());
            parsedModelListener.onResponse((Object)model);
        }
        catch (Exception e) {
            parsedModelListener.onFailure(e);
        }
    }

    public HuggingFaceModel parsePersistedConfigWithSecrets(String inferenceEntityId, TaskType taskType, Map<String, Object> config, Map<String, Object> secrets) {
        Map<String, Object> serviceSettingsMap = ServiceUtils.removeFromMapOrThrowIfNull(config, "service_settings");
        Map<String, Object> secretSettingsMap = ServiceUtils.removeFromMapOrThrowIfNull(secrets, "secret_settings");
        return this.createModel(inferenceEntityId, taskType, serviceSettingsMap, secretSettingsMap, ServiceUtils.parsePersistedConfigErrorMsg(inferenceEntityId, this.name()), ConfigurationParseContext.PERSISTENT);
    }

    public HuggingFaceModel parsePersistedConfig(String inferenceEntityId, TaskType taskType, Map<String, Object> config) {
        Map<String, Object> serviceSettingsMap = ServiceUtils.removeFromMapOrThrowIfNull(config, "service_settings");
        return this.createModel(inferenceEntityId, taskType, serviceSettingsMap, null, ServiceUtils.parsePersistedConfigErrorMsg(inferenceEntityId, this.name()), ConfigurationParseContext.PERSISTENT);
    }

    protected abstract HuggingFaceModel createModel(String var1, TaskType var2, Map<String, Object> var3, Map<String, Object> var4, String var5, ConfigurationParseContext var6);

    @Override
    public void doInfer(Model model, List<String> input, Map<String, Object> taskSettings, InputType inputType, TimeValue timeout, ActionListener<InferenceServiceResults> listener) {
        if (!(model instanceof HuggingFaceModel)) {
            listener.onFailure((Exception)ServiceUtils.createInvalidModelException(model));
            return;
        }
        HuggingFaceModel huggingFaceModel = (HuggingFaceModel)model;
        HuggingFaceActionCreator actionCreator = new HuggingFaceActionCreator(this.getSender(), this.getServiceComponents());
        ExecutableAction action = huggingFaceModel.accept(actionCreator);
        action.execute(new DocumentsOnlyInput(input), timeout, listener);
    }

    @Override
    protected void doInfer(Model model, String query, List<String> input, Map<String, Object> taskSettings, InputType inputType, TimeValue timeout, ActionListener<InferenceServiceResults> listener) {
        throw new UnsupportedOperationException("Hugging Face service does not support inference with query input");
    }
}

