/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.services.googlevertexai.embeddings;

import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.common.ValidationException;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.inference.TaskSettings;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.inference.services.ServiceUtils;
import org.elasticsearch.xpack.inference.services.googlevertexai.embeddings.GoogleVertexAiEmbeddingsRequestTaskSettings;

public class GoogleVertexAiEmbeddingsTaskSettings
implements TaskSettings {
    public static final String NAME = "google_vertex_ai_embeddings_task_settings";
    public static final String AUTO_TRUNCATE = "auto_truncate";
    public static final GoogleVertexAiEmbeddingsTaskSettings EMPTY_SETTINGS = new GoogleVertexAiEmbeddingsTaskSettings(Boolean.valueOf(null));
    private final Boolean autoTruncate;

    public static GoogleVertexAiEmbeddingsTaskSettings fromMap(Map<String, Object> map) {
        ValidationException validationException = new ValidationException();
        Boolean autoTruncate = ServiceUtils.extractOptionalBoolean(map, AUTO_TRUNCATE, validationException);
        if (!validationException.validationErrors().isEmpty()) {
            throw validationException;
        }
        return new GoogleVertexAiEmbeddingsTaskSettings(autoTruncate);
    }

    public static GoogleVertexAiEmbeddingsTaskSettings of(GoogleVertexAiEmbeddingsTaskSettings originalSettings, GoogleVertexAiEmbeddingsRequestTaskSettings requestSettings) {
        Boolean autoTruncate = requestSettings.autoTruncate() == null ? originalSettings.autoTruncate : requestSettings.autoTruncate();
        return new GoogleVertexAiEmbeddingsTaskSettings(autoTruncate);
    }

    public GoogleVertexAiEmbeddingsTaskSettings(@Nullable Boolean autoTruncate) {
        this.autoTruncate = autoTruncate;
    }

    public GoogleVertexAiEmbeddingsTaskSettings(StreamInput in) throws IOException {
        this.autoTruncate = in.readOptionalBoolean();
    }

    public Boolean autoTruncate() {
        return this.autoTruncate;
    }

    public String getWriteableName() {
        return NAME;
    }

    public TransportVersion getMinimalSupportedVersion() {
        return TransportVersions.ML_INFERENCE_GOOGLE_VERTEX_AI_EMBEDDINGS_ADDED;
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeOptionalBoolean(this.autoTruncate);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        if (this.autoTruncate != null) {
            builder.field(AUTO_TRUNCATE, this.autoTruncate);
        }
        builder.endObject();
        return builder;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        GoogleVertexAiEmbeddingsTaskSettings that = (GoogleVertexAiEmbeddingsTaskSettings)object;
        return Objects.equals(this.autoTruncate, that.autoTruncate);
    }

    public int hashCode() {
        return Objects.hash(this.autoTruncate);
    }
}

