/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.services.elasticsearch;

import java.io.IOException;
import java.util.Arrays;
import java.util.Map;
import org.elasticsearch.common.ValidationException;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.index.mapper.vectors.DenseVectorFieldMapper;
import org.elasticsearch.inference.SimilarityMeasure;
import org.elasticsearch.xpack.inference.services.ServiceUtils;
import org.elasticsearch.xpack.inference.services.elasticsearch.ElasticsearchInternalService;
import org.elasticsearch.xpack.inference.services.elasticsearch.ElasticsearchInternalServiceSettings;
import org.elasticsearch.xpack.inference.services.settings.InternalServiceSettings;

public class MultilingualE5SmallInternalServiceSettings
extends ElasticsearchInternalServiceSettings {
    public static final String NAME = "multilingual_e5_small_service_settings";
    static final int DIMENSIONS = 384;
    static final SimilarityMeasure SIMILARITY = SimilarityMeasure.COSINE;

    public MultilingualE5SmallInternalServiceSettings(int numAllocations, int numThreads, String modelId) {
        super(numAllocations, numThreads, modelId);
    }

    public MultilingualE5SmallInternalServiceSettings(StreamInput in) throws IOException {
        super(in.readVInt(), in.readVInt(), in.readString());
    }

    public static InternalServiceSettings.Builder fromMap(Map<String, Object> map) {
        ValidationException validationException = new ValidationException();
        RequestFields requestFields = MultilingualE5SmallInternalServiceSettings.extractRequestFields(map, validationException);
        if (!validationException.validationErrors().isEmpty()) {
            throw validationException;
        }
        return MultilingualE5SmallInternalServiceSettings.createBuilder(requestFields);
    }

    private static RequestFields extractRequestFields(Map<String, Object> map, ValidationException validationException) {
        Integer numAllocations = ServiceUtils.extractRequiredPositiveInteger(map, "num_allocations", "service_settings", validationException);
        Integer numThreads = ServiceUtils.extractRequiredPositiveInteger(map, "num_threads", "service_settings", validationException);
        String modelId = ServiceUtils.removeAsType(map, "model_id", String.class);
        if (modelId != null && !ElasticsearchInternalService.MULTILINGUAL_E5_SMALL_VALID_IDS.contains(modelId)) {
            validationException.addValidationError("unknown Multilingual-E5-Small model ID [" + modelId + "]. Valid IDs are " + Arrays.toString(ElasticsearchInternalService.MULTILINGUAL_E5_SMALL_VALID_IDS.toArray()));
        }
        return new RequestFields(numAllocations, numThreads, modelId);
    }

    private static InternalServiceSettings.Builder createBuilder(RequestFields requestFields) {
        InternalServiceSettings.Builder builder = new InternalServiceSettings.Builder(){

            @Override
            public MultilingualE5SmallInternalServiceSettings build() {
                return new MultilingualE5SmallInternalServiceSettings(this.getNumAllocations(), this.getNumThreads(), this.getModelId());
            }
        };
        builder.setNumAllocations(requestFields.numAllocations);
        builder.setNumThreads(requestFields.numThreads);
        builder.setModelId(requestFields.modelId);
        return builder;
    }

    @Override
    public boolean isFragment() {
        return super.isFragment();
    }

    @Override
    public String getWriteableName() {
        return NAME;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
    }

    public SimilarityMeasure similarity() {
        return SIMILARITY;
    }

    public Integer dimensions() {
        return 384;
    }

    public DenseVectorFieldMapper.ElementType elementType() {
        return DenseVectorFieldMapper.ElementType.FLOAT;
    }

    private record RequestFields(@Nullable Integer numAllocations, @Nullable Integer numThreads, @Nullable String modelId) {
    }
}

